/* 	THexPreference.java
 *	Copyright (c) 2010, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: Jan 2, 2010
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.brains2b.thex.editor;

import org.brains2b.swingext.conf.UserPreference;

/**
 * Implementation of {@link UserPreference} to save preferences as 'thexeditor.properties'
 * and set the default properties for {@link THexEditor}
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version $Revision$ $Date$
 */
public class THexPreference extends UserPreference {

	/**
	 * Constructor
	 */
	public THexPreference() {
		super("thexeditor.properties");
	}
	
	/**
	 * override to set default properties
	 */
	@Override
	public void load() {
		//set defaults
		setProperty("thex.application.size", "800,600");
		setProperty("thex.ascii.visible", "false");
		setProperty("thex.color.select", "");
		//setProperty("thex.font.ascii", "");
		setProperty("thex.color.foreground", "");
		setProperty("thex.font.binary", "");
		setProperty("thex.color.background", "");
		super.load();
	}

}
