/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.brains2b.swingext.mask.InputValidator;
import org.brains2b.swingext.mask.MaskException;
import org.brains2b.swingext.mask.MaskedField;
import org.brains2b.util.StringHelper;

public class TextValidator
extends InputVerifier
implements InputValidator {
    private String m_mask;
    private Exception m_ex;
    private boolean m_alignRight;

    public TextValidator(String mask) {
        if (mask != null && mask.length() != 0 && mask.charAt(0) == '>') {
            this.m_alignRight = true;
            mask = mask.substring(1);
        }
        this.m_mask = mask;
    }

    public boolean verify(JComponent input) {
        if (this.m_mask == null) {
            return true;
        }
        if (!(input instanceof JTextField)) {
            return false;
        }
        JTextField txt = (JTextField)input;
        String inTxt = txt.getText();
        if (inTxt == null || inTxt.length() == 0) {
            return true;
        }
        if (this.m_alignRight && inTxt.length() < this.m_mask.length()) {
            inTxt = StringHelper.leftPad(inTxt, " ", this.getMaskElementLength());
        }
        try {
            if (this.isMasked(inTxt)) {
                return true;
            }
            inTxt = this.getMasked(inTxt);
            if (txt instanceof MaskedField) {
                ((MaskedField)txt).setTextWithMask(inTxt);
            } else {
                txt.setText(inTxt);
            }
            return true;
        }
        catch (MaskException mex) {
            this.m_ex = mex;
            return false;
        }
    }

    private boolean isMasked(String txt) throws MaskException {
        if (txt.length() > this.m_mask.length()) {
            throw new MaskException(200);
        }
        for (int i = 0; i < txt.length(); ++i) {
            if (this.isValid(txt.charAt(i), i)) continue;
            return false;
        }
        return true;
    }

    private boolean isValid(char c, int i) {
        char m = this.m_mask.charAt(i);
        if (Character.isDigit(c) && m != '@' && m != '?' && m != '9') {
            return false;
        }
        if (Character.isLetter(c) && m != '@' && m != '?' && m != 'A') {
            return false;
        }
        if (c == ' ' && m != '?' && m != ' ') {
            return false;
        }
        return c == m || m == '@' || m == '?' || m == '9' || m == 'A';
    }

    private String getMasked(String txt) throws MaskException {
        StringBuffer sb = new StringBuffer();
        if (txt.length() >= this.m_mask.length()) {
            throw new MaskException(200);
        }
        int dif = 0;
        for (int i = 0; i < this.m_mask.length(); ++i) {
            char m = this.m_mask.charAt(i);
            if (i - dif < txt.length() && this.isValid(txt.charAt(i - dif), i)) {
                sb.append(txt.charAt(i - dif));
                continue;
            }
            if (m != '@' && m != '9' && m != 'A' && m != '?') {
                sb.append(m);
                ++dif;
                continue;
            }
            if (i - dif != txt.length() || m == '?') continue;
            throw new MaskException(200);
        }
        return sb.toString();
    }

    public String getErrorMessage() {
        return this.m_ex.getMessage();
    }

    public String getString(String txt) {
        return this.getString(txt, String.class);
    }

    public String getString(String txt, Class c) {
        return StringHelper.baseOnly(txt);
    }

    public String getLocalizedMessage() {
        return this.m_ex.getLocalizedMessage();
    }

    private int getMaskElementLength() {
        int cnt = 0;
        for (int i = 0; i < this.m_mask.length(); ++i) {
            char c = this.m_mask.charAt(i);
            if (c != '?' && c != '9' && c != '@' && c != 'A') continue;
            ++cnt;
        }
        return cnt;
    }
}

