/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import java.util.Locale;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.brains2b.swingext.mask.InputValidator;
import org.brains2b.swingext.mask.MaskException;
import org.brains2b.swingext.mask.MaskedField;
import org.brains2b.util.StringHelper;

public class NumberValidator
extends InputVerifier
implements InputValidator {
    private static char FRACTION = (char)44;
    private static char THOUSANDSEP = (char)46;
    private String m_mask = "##.##9,99";
    private Exception m_ex;

    public NumberValidator() {
    }

    public NumberValidator(String mask) {
        this(mask, Locale.getDefault());
    }

    public NumberValidator(String mask, Locale locale) {
        this.setLocale(locale);
        this.setMask(mask);
    }

    public boolean verify(JComponent input) {
        boolean negative = false;
        if (!(input instanceof JTextField)) {
            return false;
        }
        JTextField txt = (JTextField)input;
        String inTxt = txt.getText();
        if (inTxt == null || inTxt.length() == 0) {
            return true;
        }
        if (inTxt.charAt(0) == '-') {
            inTxt = inTxt.substring(1);
            negative = true;
        } else if (inTxt.charAt(inTxt.length() - 1) == '-') {
            inTxt = inTxt.substring(0, inTxt.length() - 1);
            negative = true;
        }
        try {
            Integer.parseInt(StringHelper.baseOnly(inTxt));
        }
        catch (NumberFormatException nfex) {
            this.m_ex = new MaskException(100);
            return false;
        }
        try {
            if (this.isMasked(inTxt) && !negative) {
                return true;
            }
            inTxt = (negative && !"0".equals(inTxt) ? "-" : "") + this.getMasked(inTxt);
            if (txt instanceof MaskedField) {
                ((MaskedField)txt).setTextWithMask(inTxt);
            } else {
                txt.setText(inTxt);
            }
            return true;
        }
        catch (MaskException mex) {
            this.m_ex = mex;
            return false;
        }
    }

    private boolean isMasked(String txt) throws MaskException {
        int i;
        int dif = this.m_mask.length() - txt.length();
        if (dif < 0) {
            return false;
        }
        int mdx = this.m_mask.lastIndexOf(FRACTION);
        int n = mdx = mdx == -1 ? 0 : this.m_mask.length() - mdx;
        if (mdx >= txt.length()) {
            return false;
        }
        for (i = 0; i < txt.length(); ++i) {
            if (this.isValid(txt.charAt(i), i + dif)) continue;
            return false;
        }
        for (i = 0; i < dif; ++i) {
            if (this.m_mask.charAt(i) != '9') continue;
            return false;
        }
        return true;
    }

    private boolean isValid(char c, int i) {
        char m = this.m_mask.charAt(i);
        if (Character.isDigit(c) && m != '9' && m != '#') {
            return false;
        }
        if (c == '.' && m != '.') {
            return false;
        }
        if (c == ',' && m != ',') {
            return false;
        }
        return c != ' ' || m == ' ' || m == '#';
    }

    private String getMasked(String txt) throws MaskException {
        int idx;
        StringBuffer sb = new StringBuffer();
        txt = txt.replace('.', FRACTION);
        int mdx = this.m_mask.lastIndexOf(FRACTION);
        int n = idx = txt.indexOf(FRACTION) != -1 ? txt.indexOf(FRACTION) : txt.length();
        if (mdx != -1) {
            sb.append(this.getRightPart(txt.substring(0, idx), this.m_mask.substring(0, mdx)));
            sb.append(this.getLeftPart(txt.substring(idx), this.m_mask.substring(mdx)));
        } else {
            sb.append(this.getRightPart(txt.substring(0, idx), this.m_mask));
        }
        return sb.toString();
    }

    private String getLeftPart(String part, String maskPart) throws MaskException {
        StringBuffer sb = new StringBuffer();
        int maskBefore = this.m_mask.length() - maskPart.length();
        for (int mdx = 0; mdx < maskPart.length(); ++mdx) {
            if (mdx < part.length() && this.isValid(part.charAt(mdx), maskBefore + mdx)) {
                sb.append(part.charAt(mdx));
                continue;
            }
            char m = maskPart.charAt(mdx);
            if (m == FRACTION) {
                sb.append(FRACTION);
                continue;
            }
            if (m == '9') {
                sb.append('0');
                continue;
            }
            if (m == '#') continue;
            throw new MaskException(100);
        }
        if (sb.length() == 1 && sb.charAt(0) == FRACTION) {
            return "";
        }
        return sb.toString();
    }

    private String getRightPart(String part, String maskPart) throws MaskException {
        StringBuffer sb = new StringBuffer(part);
        int dif = maskPart.length() - part.length();
        if (dif < 0) {
            throw new MaskException(1);
        }
        for (int mdx = maskPart.length() - 1; mdx >= 0; --mdx) {
            int idx = mdx - dif;
            if (idx >= 0 && this.isValid(part.charAt(idx), mdx)) continue;
            char m = maskPart.charAt(mdx);
            if (idx >= 0 && (m == THOUSANDSEP || m == ' ')) {
                sb.insert(idx + 1, m);
            } else if (m != '9' && m != '#' && m != THOUSANDSEP && m != ' ') {
                sb.insert(idx + 1, m);
            } else if (m == '9') {
                sb.insert(idx + 1, '0');
            } else if (idx >= 0 && m != '#') {
                throw new MaskException(100);
            }
            --dif;
        }
        if (sb.toString().length() > maskPart.length()) {
            throw new MaskException(1);
        }
        return sb.toString();
    }

    public String getErrorMessage() {
        return this.m_ex.getMessage();
    }

    public String getString(String txt) {
        return this.getString(txt, Integer.class);
    }

    public String getString(String txt, Class c) {
        if (txt == null) {
            return null;
        }
        boolean negative = false;
        if (txt != null && txt.length() > 0 && txt.charAt(0) == '-') {
            negative = true;
        }
        return (negative ? "-" : "") + this.getNumberAsString(txt, c);
    }

    public String makeString(String txt) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        boolean negative = false;
        if (txt.charAt(0) == '-') {
            txt = txt.substring(1);
            negative = true;
        }
        if (txt.charAt(0) == '0' && this.m_mask.indexOf(57) == -1) {
            return null;
        }
        txt = txt.replace('.', FRACTION);
        StringBuffer sb = new StringBuffer(txt);
        int dif = this.m_mask.indexOf(FRACTION);
        if (dif != -1 && txt.indexOf(FRACTION) == -1) {
            dif = txt.length() - (this.m_mask.length() - dif) + 1;
            if (dif <= 0) {
                sb.insert(0, StringHelper.leftPad("0", "0", Math.abs(dif) + 1));
                dif = 1;
            }
            if (dif >= 0) {
                sb.insert(dif, FRACTION);
            }
        } else if (dif == -1 && txt.indexOf(FRACTION) != -1) {
            sb.delete(Math.max(0, txt.indexOf(FRACTION)), txt.length());
        }
        if (negative) {
            sb.insert(0, '-');
        }
        try {
            return this.getMasked(sb.toString());
        }
        catch (MaskException mex) {
            this.m_ex = mex;
            return sb.toString();
        }
    }

    private String getNumberAsString(String txt, Class c) {
        if (txt == null || txt.length() == 0) {
            return txt;
        }
        String result = null;
        if (c == Integer.class || c == Long.class) {
            result = StringHelper.baseOnly(txt);
            result = String.valueOf(Integer.parseInt(result));
        } else {
            int idx = txt.indexOf(FRACTION);
            if (idx != -1) {
                result = StringHelper.baseOnly(txt.substring(0, idx)) + txt.substring(idx);
                result = result.replace(FRACTION, '.');
            } else {
                result = StringHelper.baseOnly(txt);
            }
        }
        return result;
    }

    public String getLocalizedMessage() {
        return this.m_ex.getLocalizedMessage();
    }

    private void setLocale(Locale loc) {
        if ("en".equals(loc.getLanguage())) {
            FRACTION = (char)46;
            THOUSANDSEP = (char)44;
        } else {
            FRACTION = (char)44;
            THOUSANDSEP = (char)46;
        }
    }

    private void setMask(String mask) {
        this.m_mask = mask;
    }

    protected void setException(MaskException mex) {
        this.m_ex = mex;
    }
}

