/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import java.util.ArrayList;
import java.util.Locale;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.brains2b.swingext.mask.DateValidator;
import org.brains2b.swingext.mask.InputValidator;
import org.brains2b.swingext.mask.NumberValidator;
import org.brains2b.swingext.mask.TextValidator;
import org.brains2b.swingext.mask.TimeValidator;

public class MaskedField
extends JTextField {
    private int m_type;
    private InputValidator m_validator;
    public static final int TEXT = 1;
    public static final int NUMBER = 2;
    public static final int DATE = 3;
    public static final int TIME = 4;

    public MaskedField(String mask, int type) {
        this.m_type = type;
        if (this.getColumns() == 0) {
            this.setColumns(mask.length());
        }
        switch (type) {
            case 1: {
                this.setHorizontalAlignment(2);
                this.m_validator = new TextValidator(mask);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(4);
                this.m_validator = new NumberValidator(mask);
                break;
            }
            case 3: {
                this.m_validator = new DateValidator(Locale.getDefault(), mask);
                break;
            }
            case 4: {
                this.m_validator = new TimeValidator(mask);
            }
        }
        super.setInputVerifier((InputVerifier)((Object)this.m_validator));
    }

    public MaskedField(InputValidator validator) {
        this.m_validator = validator;
        super.setInputVerifier((InputVerifier)((Object)validator));
        this.m_type = validator instanceof TextValidator ? 1 : (validator instanceof DateValidator ? 3 : 2);
    }

    public void setText(String t) {
        if (t == null || !t.equals(super.getText())) {
            super.setText(t);
            if (this.m_validator != null) {
                this.m_validator.verify(this);
            }
        }
    }

    public void setString(String s) {
        if (this.m_validator instanceof NumberValidator) {
            s = ((NumberValidator)this.m_validator).makeString(s);
        }
        this.setText(s);
    }

    public String getString() {
        return this.m_validator.getString(this.getText());
    }

    public String getString(Class c) {
        return this.m_validator.getString(this.getText(), c);
    }

    void setTextWithMask(String txt) {
        super.setText(txt);
    }

    public int getType() {
        return this.m_type;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        if (inputVerifier == null) {
            super.setInputVerifier(null);
            return;
        }
        if (this.getInputVerifier() instanceof InputVerifierWrapper) {
            ((InputVerifierWrapper)this.getInputVerifier()).addInputVerifier(inputVerifier);
            return;
        }
        if (this.getInputVerifier() instanceof InputValidator) {
            InputVerifierWrapper verifier = new InputVerifierWrapper();
            verifier.addInputVerifier(this.getInputVerifier());
            verifier.addInputVerifier(inputVerifier);
            inputVerifier = verifier;
        }
        super.setInputVerifier(inputVerifier);
    }

    class InputVerifierWrapper
    extends InputVerifier {
        private ArrayList m_verifiers = new ArrayList();

        InputVerifierWrapper() {
        }

        public boolean verify(JComponent input) {
            for (int i = 0; i < this.m_verifiers.size(); ++i) {
                boolean b = ((InputVerifier)this.m_verifiers.get(i)).verify(input);
                if (b) continue;
                return b;
            }
            return true;
        }

        public void addInputVerifier(InputVerifier verifier) {
            this.m_verifiers.add(verifier);
        }

        public void removeInputVerifier(InputVerifier verifier) {
            this.m_verifiers.remove(verifier);
        }
    }
}

