/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.brains2b.util.StringHelper;

public class MaskException
extends Exception {
    public static final int VALUE_TO_LARGE = 1;
    public static final int NOT_VALID_NUMBER = 100;
    public static final int DOESNT_COMPLY = 200;
    public static final int NOT_VALID_DATE = 300;
    private int errorNo;

    public MaskException() {
    }

    public MaskException(int errorNo) {
        this.errorNo = errorNo;
    }

    public MaskException(String s) {
        super(s);
    }

    public int getErrorNo() {
        return this.errorNo;
    }

    public String getMessage() {
        if (this.errorNo == 0) {
            return super.getMessage();
        }
        switch (this.errorNo) {
            case 200: {
                return "Value doesn't comply with mask";
            }
            case 1: {
                return "Value is too large for field";
            }
            case 300: {
                return "Not a valid date";
            }
            case 100: {
                return "Not a valid number";
            }
        }
        return "Unknown MaskException";
    }

    public String getLocalizedMessage() {
        if (this.errorNo == 0) {
            return super.getLocalizedMessage();
        }
        ResourceBundle rb = ResourceBundle.getBundle("org.brains2b.swingext.resource.messages", Locale.getDefault());
        String key = "MaskException." + StringHelper.leftPad(String.valueOf(this.errorNo), "0", 5);
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException mrex) {
            return this.getMessage();
        }
    }
}

