/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.brains2b.swingext.mask.InputValidator;
import org.brains2b.swingext.mask.MaskException;
import org.brains2b.util.DateHelper;

public class DateValidator
extends InputVerifier
implements InputValidator {
    private String m_mask = "dd-MMM-yyyy";
    private Locale m_locale = Locale.getDefault();
    private Exception m_ex;

    public DateValidator() {
    }

    public DateValidator(Locale locale) {
        this.m_locale = locale;
    }

    public DateValidator(Locale locale, String mask) {
        this.m_locale = locale;
        this.m_mask = mask;
    }

    public boolean verify(JComponent input) {
        if (!(input instanceof JTextField)) {
            return false;
        }
        JTextField txt = (JTextField)input;
        String inTxt = txt.getText();
        if (inTxt == null || inTxt.length() == 0) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.m_mask, this.m_locale);
        sdf.setLenient(false);
        try {
            sdf.parse(inTxt);
            return true;
        }
        catch (ParseException pex) {
            try {
                Date dt = this.findFormat(inTxt);
                txt.setText(sdf.format(dt));
                return true;
            }
            catch (MaskException mex) {
                this.m_ex = mex;
                return false;
            }
        }
    }

    private Date findFormat(String txt) throws MaskException {
        try {
            return DateHelper.toDate(txt, this.m_locale);
        }
        catch (NumberFormatException nfex) {
            throw new MaskException(300);
        }
    }

    public String getErrorMessage() {
        return this.m_ex.getMessage();
    }

    public String getString(String txt) {
        return this.getString(txt, Date.class);
    }

    public String getString(String txt, Class c) {
        if (txt == null || txt.length() == 0) {
            return null;
        }
        if (c == Date.class) {
            try {
                if (this.m_mask.equals("dd-MMM-yyyy")) {
                    return txt;
                }
                SimpleDateFormat sdf = new SimpleDateFormat(this.m_mask);
                Date d = sdf.parse(txt);
                sdf.applyPattern("dd-MMM-yyyy");
                return sdf.format(d);
            }
            catch (ParseException pex) {
                pex.printStackTrace();
                return null;
            }
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.m_mask);
            Date d = sdf.parse(txt);
            sdf.applyPattern("yyyyMMdd");
            return sdf.format(d);
        }
        catch (ParseException pex) {
            pex.printStackTrace();
            return null;
        }
    }

    public String getLocalizedMessage() {
        return this.m_ex.getLocalizedMessage();
    }
}

