/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.mask;

import java.text.ParseException;
import java.util.Stack;
import org.brains2b.util.StringHelper;

public class CalculateParser {
    public boolean isCalculation(String text) {
        if (StringHelper.isEmpty(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '(' || c == ')' || this.isOperation(c) || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public String parse(String text) throws ParseException {
        double d = this.parsedouble(text);
        return String.valueOf(d);
    }

    public double parsedouble(String text) throws ParseException {
        if (StringHelper.isEmpty(text)) {
            throw new ParseException("Cannot parse an empty String", 0);
        }
        Stack<Evaluate> stack = new Stack<Evaluate>();
        Evaluate e = new Evaluate();
        StringBuffer sb = new StringBuffer();
        char lastChar = '\u0000';
        for (int i = 0; i < text.length(); ++i) {
            try {
                char c = text.charAt(i);
                switch (c) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        if (this.isOperation(lastChar)) {
                            throw new ParseException("Not a valid calculation", i - 1);
                        }
                        if (e.right != 0.0) {
                            e.left = e.getValue();
                        }
                        this.setEvaluate(e, sb);
                        e.operation = c;
                        break;
                    }
                    case ' ': {
                        break;
                    }
                    case '(': {
                        if (i > 0 && !this.isOperation(lastChar) && lastChar != '(') {
                            throw new ParseException("Brackets not usable for calculation", i - 1);
                        }
                        this.setEvaluate(e, sb);
                        stack.push(e);
                        e = new Evaluate();
                        break;
                    }
                    case ')': {
                        if (this.isOperation(lastChar) || lastChar == '(' || i == 0) {
                            throw new ParseException("Brackets not usable for calculation", i == 0 ? i : i - 1);
                        }
                        this.setEvaluate(e, sb);
                        Evaluate alt = (Evaluate)stack.pop();
                        if (alt.operation == '\u0000') {
                            alt.left = e.getValue();
                        } else {
                            alt.right = e.getValue();
                        }
                        e = alt;
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                if (c == ' ') continue;
                lastChar = c;
                continue;
            }
            catch (NumberFormatException nfex) {
                throw new ParseException("Cannot parse information:" + sb.toString(), i - sb.length());
            }
        }
        if (!stack.isEmpty()) {
            throw new ParseException("Cannot close brackets", text.length() - 1);
        }
        try {
            this.setEvaluate(e, sb);
        }
        catch (NumberFormatException nfex) {
            throw new ParseException("Cannot parse information:" + sb.toString(), text.length() - sb.length());
        }
        double d = e.getValue();
        if (d == Double.NaN || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            throw new ParseException("Calculation does not return a valid number", 0);
        }
        return d;
    }

    public Double parseDouble(String text) throws ParseException {
        double d = this.parsedouble(text);
        return d;
    }

    private final void setEvaluate(Evaluate e, StringBuffer sb) {
        if (sb.length() > 0) {
            if (e.operation == '\u0000') {
                e.left = Double.parseDouble(sb.toString());
            } else {
                e.right = Double.parseDouble(sb.toString());
                e = new Evaluate();
            }
            sb.delete(0, sb.length());
        }
    }

    private final boolean isOperation(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    static class Evaluate {
        char operation;
        double left;
        double right;

        Evaluate() {
        }

        double getValue() {
            double d = 0.0;
            switch (this.operation) {
                case '+': {
                    d = this.left + this.right;
                    break;
                }
                case '-': {
                    d = this.left - this.right;
                    break;
                }
                case '*': {
                    d = this.left * this.right;
                    break;
                }
                case '/': {
                    d = this.left / this.right;
                    break;
                }
                default: {
                    d = this.left;
                }
            }
            return d;
        }
    }
}

