/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.gui.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.brains2b.swingext.action.ExtActionMap;
import org.brains2b.swingext.gui.list.MutableListModel;

public class ExtMutableList
extends JPanel
implements ActionListener {
    public static final int ACTION_ADD = 1;
    public static final int ACTION_REMOVE = 2;
    public static final int ACTION_EDIT = 4;
    private JList m_list;
    private int m_availableActions;

    public ExtMutableList() {
        this(7);
    }

    public ExtMutableList(int availableActions) {
        this.m_availableActions = availableActions;
        this.init();
    }

    public void setFixedCellWidth(int width) {
        this.m_list.setFixedCellWidth(width);
    }

    public void setFixedCellHeight(int height) {
        this.m_list.setFixedCellHeight(height);
    }

    public void setVisibleRowCount(int visibleRowCount) {
        this.m_list.setVisibleRowCount(visibleRowCount);
    }

    public List getData() {
        return ((MutableListModel)this.m_list.getModel()).m_data;
    }

    public void setData(List l) {
        ((MutableListModel)this.m_list.getModel()).setData(l);
    }

    public void clearData() {
        if (((MutableListModel)this.m_list.getModel()).m_data != null) {
            ((MutableListModel)this.m_list.getModel()).m_data.clear();
        }
    }

    public void setData(Object[] array) {
        this.setData(Arrays.asList(array));
    }

    public void addItem(Object o) {
        ((MutableListModel)this.m_list.getModel()).addData(o);
    }

    public void replaceItem(Object o, int index) {
        ((MutableListModel)this.m_list.getModel()).m_data.set(index, o);
        ((MutableListModel)this.m_list.getModel()).fireContentsChanged(this.m_list.getModel(), index, index);
    }

    public void removeItem(int index) {
        ((MutableListModel)this.m_list.getModel()).removeData(index);
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.m_list.setCellRenderer(cellRenderer);
    }

    public Object getSelectedValue() {
        return this.m_list.getSelectedValue();
    }

    public int getSelectedIndex() {
        return this.m_list.getSelectedIndex();
    }

    public void actionPerformed(ActionEvent e) {
        ActionEvent ne = new ActionEvent(this, e.getID(), e.getActionCommand());
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionPerformed(ne);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.m_list.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.m_list.removeListSelectionListener(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void init() {
        ResourceBundle rs = ResourceBundle.getBundle("org.brains2b.swingext.resource.mutablelist");
        this.setLayout(new BorderLayout());
        this.m_list = new JList(new MutableListModel());
        this.m_list.addListSelectionListener(new ItemSelector());
        this.add((Component)new JScrollPane(this.m_list), "Center");
        ExtActionMap map = new ExtActionMap(this);
        map.addAction("ExtMutableList.Add", rs.getString("ExtMutableList.Add"), rs.getString("ExtMutableList.Add.Tooltip"), "/org/brains2b/swingext/resource/Plus16.gif", "+", '+');
        map.addAction("ExtMutableList.Edit", rs.getString("ExtMutableList.Edit"), rs.getString("ExtMutableList.Edit.Tooltip"), "/org/brains2b/swingext/resource/Edit16.gif", "+", '+');
        map.addAction("ExtMutableList.Remove", rs.getString("ExtMutableList.Remove"), rs.getString("ExtMutableList.Remove.Tooltip"), "/org/brains2b/swingext/resource/Minus16.gif", "+", '+');
        this.setActionMap(map);
        JToolBar actions = new JToolBar(1);
        actions.setFloatable(false);
        if ((this.m_availableActions & 1) == 1) {
            actions.add(this.getActionMap().get("ExtMutableList.Add"));
        }
        if ((this.m_availableActions & 4) == 4) {
            actions.add(this.getActionMap().get("ExtMutableList.Edit"));
        }
        if ((this.m_availableActions & 2) == 2) {
            actions.add(this.getActionMap().get("ExtMutableList.Remove"));
        }
        map.get("ExtMutableList.Edit").setEnabled(false);
        map.get("ExtMutableList.Remove").setEnabled(false);
        this.add((Component)actions, "East");
        actions.setMinimumSize(actions.getPreferredSize());
    }

    public synchronized void setDropTarget(DropTarget dt) {
        super.setDropTarget(dt);
        this.m_list.setDropTarget(dt);
    }

    public Object getPrototypeCellValue() {
        return this.m_list.getPrototypeCellValue();
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        this.m_list.setPrototypeCellValue(prototypeCellValue);
    }

    class ItemSelector
    implements ListSelectionListener {
        ItemSelector() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && e.getFirstIndex() >= 0) {
                ExtMutableList.this.getActionMap().get("ExtMutableList.Edit").setEnabled(true);
                ExtMutableList.this.getActionMap().get("ExtMutableList.Remove").setEnabled(true);
            }
        }
    }
}

