/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.gui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;

public class TriStateCheckbox
extends JCheckBox {
    public TriStateCheckbox(String text) {
        super(text);
        this.setModel(new TriStateModel());
        this.setIcon(new TriStateIcon(UIManager.getIcon("CheckBox.icon")));
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setSelected(boolean b) {
        this.getModel().setSelected(b);
    }

    public boolean isIndeterminate() {
        return ((TriStateModel)this.getModel()).isIndeterminate();
    }

    public void setIndeterminate(boolean b) {
        ((TriStateModel)this.getModel()).setIndeterminate(b);
    }

    class TriStateIcon
    implements Icon {
        private Icon m_delegate;

        public TriStateIcon(Icon delegate) {
            this.m_delegate = delegate;
        }

        public int getIconHeight() {
            return this.m_delegate.getIconHeight();
        }

        public int getIconWidth() {
            return this.m_delegate.getIconWidth();
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.m_delegate.paintIcon(c, g, x, y);
            g.translate(x, y);
            int h = this.getIconHeight();
            int w = this.getIconWidth();
            if (TriStateCheckbox.this.isIndeterminate()) {
                g.drawLine(3, h / 2 - 1, w - 4, h / 2 - 1);
                g.drawLine(2, h / 2, w - 3, h / 2);
                g.drawLine(3, h / 2 + 1, w - 4, h / 2 + 1);
            }
        }
    }

    class TriStateModel
    extends DefaultButtonModel {
        public static final int INDETERMINATE = 32;

        TriStateModel() {
        }

        public boolean isIndeterminate() {
            return (this.stateMask & 0x20) != 0;
        }

        public void setIndeterminate(boolean b) {
            if (this.isIndeterminate() == b) {
                return;
            }
            if (b) {
                this.stateMask &= 0xFFFFFFFD;
                this.stateMask |= 0x20;
            } else {
                this.stateMask &= 0xFFFFFFDF;
            }
            this.fireStateChanged();
        }

        public void setPressed(boolean b) {
            super.setPressed(b);
            if (!this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setSelected(!this.isSelected());
                if (this.isSelected()) {
                    this.stateMask &= 0xFFFFFFDF;
                }
            }
        }
    }
}

