/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.gui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.brains2b.util.StringHelper;

public class SelectComboEditor
implements ComboBoxEditor {
    private JTextField m_editor;
    private JComboBox m_box;

    public SelectComboEditor(JComboBox box) {
        if (box == null) {
            throw new IllegalArgumentException("an instance of JComboBox is required");
        }
        this.m_box = box;
        this.m_editor = (JTextField)box.getEditor().getEditorComponent();
        this.m_editor.addFocusListener(new FocusHandler());
        this.m_editor.addCaretListener(new CaretHandler());
    }

    public void addActionListener(ActionListener l) {
        this.m_editor.addActionListener(l);
    }

    public Component getEditorComponent() {
        return this.m_editor;
    }

    public Object getItem() {
        return this.m_editor.getText();
    }

    public void removeActionListener(ActionListener l) {
        this.m_editor.removeActionListener(l);
    }

    public void selectAll() {
        this.m_editor.selectAll();
        this.m_editor.requestFocus();
    }

    public void setItem(Object anObject) {
        if (anObject == null) {
            this.m_editor.setText("");
        } else {
            this.m_editor.setText(anObject.toString());
        }
    }

    private final String findItem(String txt) {
        if (StringHelper.isEmpty(txt)) {
            return null;
        }
        String find = txt.toLowerCase();
        boolean b = true;
        for (int i = 0; i < this.m_box.getItemCount(); ++i) {
            String value = this.m_box.getItemAt(i).toString();
            String string = value = value == null ? null : value.toLowerCase();
            if (value.equals(find)) {
                return find;
            }
            if (!value.startsWith(find)) continue;
            return value;
        }
        return null;
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            JTextField fld = (JTextField)e.getSource();
            fld.selectAll();
        }

        public void focusLost(FocusEvent e) {
            JTextField fld = (JTextField)e.getSource();
            int len = fld.getText().length();
            fld.select(len, len);
        }
    }

    class CaretHandler
    implements CaretListener {
        private String m_last;
        private boolean m_running;

        CaretHandler() {
        }

        public void caretUpdate(CaretEvent e) {
            if (this.m_running) {
                return;
            }
            JTextField fld = (JTextField)e.getSource();
            final String txt = fld.getText();
            if (this.m_last == null || !this.m_last.equals(txt)) {
                final String found = SelectComboEditor.this.findItem(txt);
                if (found != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            CaretHandler.this.m_running = true;
                            SelectComboEditor.this.m_editor.setText(found);
                            SelectComboEditor.this.m_editor.select(txt.length(), found.length());
                            CaretHandler.this.m_running = false;
                        }
                    });
                }
                this.m_last = txt;
            }
        }
    }
}

