/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import org.brains2b.swingext.gui.SelectablePanel;

public class ScrollablePanel
extends JPanel
implements Scrollable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int m_orientation;
    private int m_selectedIndex = -1;
    private Dimension m_scrollableSize;
    private FocusHandler m_focusHandler;

    public ScrollablePanel(int orientation) {
        this.m_orientation = orientation;
        this.init();
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.getScrollableTracksViewportWidth()) {
            d.width += UIManager.getInt("ScrollBar.width");
        }
        return d;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.m_scrollableSize == null) {
            this.m_scrollableSize = this.getPreferredSize();
        }
        return this.m_scrollableSize;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.m_orientation == 1) {
            return visibleRect.height;
        }
        return visibleRect.width;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.m_orientation == 0;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.m_orientation == 1;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getComponentCount() == 0) {
            return 0;
        }
        if (this.m_orientation == 1) {
            return this.getComponent((int)0).getSize().height;
        }
        return this.getComponent((int)0).getSize().width;
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof Container) {
            for (int i = 0; i < ((Container)comp).getComponentCount(); ++i) {
                Component cmp = ((Container)comp).getComponent(i);
                if (!cmp.isFocusable()) continue;
                cmp.addFocusListener(this.m_focusHandler);
            }
        } else if (comp.isFocusable()) {
            comp.addFocusListener(this.m_focusHandler);
        }
        super.addImpl(comp, constraints, index);
    }

    public void remove(int index) {
        if (index == this.m_selectedIndex) {
            this.m_selectedIndex = -1;
        }
        super.remove(index);
    }

    public int getSelectedIndex() {
        return this.m_selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.m_selectedIndex != selectedIndex) {
            if (this.getComponent(selectedIndex) instanceof SelectablePanel) {
                ((SelectablePanel)((Object)this.getComponent(selectedIndex))).setSelected(true);
            }
            if (this.m_selectedIndex != -1 && this.getComponent(this.m_selectedIndex) instanceof SelectablePanel) {
                ((SelectablePanel)((Object)this.getComponent(this.m_selectedIndex))).setSelected(false);
            }
        }
        this.m_selectedIndex = selectedIndex;
    }

    private final int findIndex(Component cmp) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (cmp != this.getComponent(i)) continue;
            return i;
        }
        return -1;
    }

    private final Component getRoot(Component cmp) {
        if (cmp == null) {
            return null;
        }
        if (cmp.getParent() == this) {
            return cmp;
        }
        return this.getRoot(cmp.getParent());
    }

    private void init() {
        this.m_focusHandler = new FocusHandler();
        this.addFocusListener(this.m_focusHandler);
        this.setLayout(new BoxLayout(this, this.m_orientation == 0 ? 0 : 1));
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            if (ScrollablePanel.this.getRoot(e.getOppositeComponent()) == null) {
                boolean needRepaint = false;
                for (int i = 0; i < ScrollablePanel.this.getComponentCount(); ++i) {
                    if (!(ScrollablePanel.this.getComponent(i) instanceof SelectablePanel)) continue;
                    needRepaint = true;
                    ((SelectablePanel)((Object)ScrollablePanel.this.getComponent(i))).setSelected(false);
                }
                if (needRepaint) {
                    ScrollablePanel.this.repaint();
                }
            }
            Component root = ScrollablePanel.this.getRoot(e.getComponent());
            ScrollablePanel.this.m_selectedIndex = ScrollablePanel.this.findIndex(root);
            if (root instanceof SelectablePanel) {
                ((SelectablePanel)((Object)root)).setSelected(true);
                ScrollablePanel.this.repaint();
            }
        }

        public void focusLost(FocusEvent e) {
            Component root = ScrollablePanel.this.getRoot(e.getComponent());
            Component oppRoot = ScrollablePanel.this.getRoot(e.getOppositeComponent());
            if (root != null && oppRoot != null && root != oppRoot) {
                ScrollablePanel.this.m_selectedIndex = -1;
                if (root instanceof SelectablePanel) {
                    ((SelectablePanel)((Object)root)).setSelected(false);
                    ScrollablePanel.this.repaint();
                }
            }
        }
    }
}

