/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.gui;

import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;

public class ExtButtonGroup
extends ButtonGroup {
    private String m_toolTipText;
    private KeyEventHandler m_keyHandler = new KeyEventHandler();

    public void add(AbstractButton b) {
        super.add(b);
        if (b.getToolTipText() == null) {
            b.setToolTipText(this.m_toolTipText);
        }
        b.setFocusTraversalKeysEnabled(false);
        b.addKeyListener(this.m_keyHandler);
    }

    public void remove(AbstractButton b) {
        super.remove(b);
        b.setFocusTraversalKeysEnabled(true);
        b.removeKeyListener(this.m_keyHandler);
    }

    public Iterator iterator() {
        return this.buttons.iterator();
    }

    AbstractButton next(AbstractButton b) {
        int idx = this.buttons.indexOf(b);
        if (idx != -1 && idx + 1 < this.buttons.size()) {
            return (AbstractButton)this.buttons.get(++idx);
        }
        return null;
    }

    AbstractButton previous(AbstractButton b) {
        int idx = this.buttons.indexOf(b);
        if (idx > 0) {
            return (AbstractButton)this.buttons.get(--idx);
        }
        return null;
    }

    public String getToolTipText() {
        return this.m_toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.m_toolTipText = toolTipText;
    }

    public void setEnabled(boolean b) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((AbstractButton)it.next()).setEnabled(b);
        }
    }

    public void setVisible(boolean b) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((AbstractButton)it.next()).setVisible(b);
        }
    }

    class KeyEventHandler
    extends KeyAdapter {
        KeyEventHandler() {
        }

        public void keyPressed(KeyEvent e) {
            AbstractButton btn;
            AbstractButton next;
            if (e.getKeyCode() == 9) {
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (e.isShiftDown()) {
                    kfm.focusPreviousComponent((AbstractButton)ExtButtonGroup.this.buttons.firstElement());
                } else {
                    kfm.focusNextComponent((AbstractButton)ExtButtonGroup.this.buttons.lastElement());
                }
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 40) {
                AbstractButton btn2 = (AbstractButton)e.getSource();
                AbstractButton prev = ExtButtonGroup.this.previous(btn2);
                if (prev != null) {
                    prev.requestFocusInWindow();
                }
            } else if ((e.getKeyCode() == 39 || e.getKeyCode() == 38) && (next = ExtButtonGroup.this.next(btn = (AbstractButton)e.getSource())) != null) {
                next.requestFocusInWindow();
            }
        }
    }
}

