/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.form;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.brains2b.swingext.form.Form;

public class FormAction
extends JPanel {
    public static final int BTN_OK = 1;
    public static final int BTN_CANCEL = 2;
    public static final int BTN_OK_CANCEL = 3;
    public static final int BTN_APPLY = 4;
    public static final int BTN_UNDO = 8;
    public static final int BTN_ALL = 15;
    private JButton m_ok;
    private JButton m_undo;
    private JButton m_apply;
    private JButton m_cancel;
    private Form m_form;

    public FormAction(Form form) {
        this(form, 3);
    }

    public FormAction(Form form, int buttons) {
        this.m_form = form;
        this.init();
        this.showButtons(buttons);
    }

    public FormAction(Form form, int buttons, ResourceBundle msg) {
        this(form, buttons);
        this.setLSText(msg);
    }

    public void setFont(Font font) {
        super.setFont(font);
        Component[] cmps = this.getComponents();
        for (int i = 0; i < cmps.length; ++i) {
            cmps[i].setFont(font);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_apply.setEnabled(enabled);
        this.m_ok.setEnabled(enabled);
        this.m_cancel.setEnabled(enabled);
        this.m_undo.setEnabled(enabled);
    }

    public void setEnabled(int buttonId, boolean enabled) {
        if ((buttonId & 8) == 8) {
            this.m_undo.setEnabled(enabled);
        }
        if ((buttonId & 2) == 2) {
            this.m_cancel.setEnabled(enabled);
        }
        if ((buttonId & 1) == 1) {
            this.m_ok.setEnabled(enabled);
        }
        if ((buttonId & 4) == 4) {
            this.m_apply.setEnabled(enabled);
        }
    }

    public JButton getButton(int buttonId) {
        if ((buttonId & 8) == 8) {
            return this.m_undo;
        }
        if ((buttonId & 2) == 2) {
            return this.m_cancel;
        }
        if ((buttonId & 1) == 1) {
            return this.m_ok;
        }
        if ((buttonId & 4) == 4) {
            return this.m_apply;
        }
        return null;
    }

    public void setDefaultButton(int buttonId) {
        if (this.m_form == null || this.m_form.getRootPane() == null) {
            return;
        }
        this.m_form.getRootPane().setDefaultButton(this.getButton(buttonId));
    }

    private void init() {
        ActionEventHandler aeh = new ActionEventHandler();
        this.setBorder(new EmptyBorder(10, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 0));
        this.m_ok = new JButton("Ok");
        this.m_ok.setMnemonic('o');
        this.m_ok.addActionListener(aeh);
        this.add(this.m_ok);
        this.m_apply = new JButton("Apply");
        this.m_apply.setMnemonic('a');
        this.m_apply.addActionListener(aeh);
        this.add(this.m_apply);
        this.add(new JPanel());
        this.m_undo = new JButton("Undo");
        this.m_undo.setMnemonic('u');
        this.m_undo.setVerifyInputWhenFocusTarget(false);
        this.m_undo.addActionListener(aeh);
        this.add(this.m_undo);
        this.m_cancel = new JButton("Cancel");
        this.m_cancel.setMnemonic('c');
        this.m_cancel.setVerifyInputWhenFocusTarget(false);
        this.m_cancel.addActionListener(aeh);
        this.add(this.m_cancel);
    }

    private void showButtons(int buttons) {
        this.m_undo.setVisible((buttons & 8) == 8);
        this.m_apply.setVisible((buttons & 4) == 4);
        this.m_ok.setVisible((buttons & 1) == 1);
        this.m_cancel.setVisible((buttons & 2) == 2);
    }

    private void setLSText(ResourceBundle msg) {
        try {
            this.m_ok.setText(msg.getString("FormAction.btnOkText"));
            this.m_ok.setToolTipText(msg.getString("FormAction.btnOkTip"));
            this.m_ok.setMnemonic(msg.getString("FormAction.btnOkMnem").charAt(0));
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        try {
            this.m_undo.setText(msg.getString("FormAction.btnUndoText"));
            this.m_undo.setToolTipText(msg.getString("FormAction.btnUndoTip"));
            this.m_undo.setMnemonic(msg.getString("FormAction.btnUndoMnem").charAt(0));
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        try {
            this.m_apply.setText(msg.getString("FormAction.btnApplyText"));
            this.m_apply.setToolTipText(msg.getString("FormAction.btnApplyTip"));
            this.m_apply.setMnemonic(msg.getString("FormAction.btnApplyMnem").charAt(0));
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        try {
            this.m_cancel.setText(msg.getString("FormAction.btnCancelText"));
            this.m_cancel.setToolTipText(msg.getString("FormAction.btnCancelTip"));
            this.m_cancel.setMnemonic(msg.getString("FormAction.btnCancelMnem").charAt(0));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FormAction.this.m_ok) {
                FormAction.this.m_form.performOk();
            } else if (e.getSource() == FormAction.this.m_undo) {
                FormAction.this.m_form.performUndo();
            } else if (e.getSource() == FormAction.this.m_apply) {
                FormAction.this.m_form.performApply();
            } else if (e.getSource() == FormAction.this.m_cancel) {
                FormAction.this.m_form.performCancel();
            }
        }
    }
}

