/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;

public class EasyForm
extends JPanel
implements Form {
    public static final int ADD = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int VIEW = 3;
    public static final int SEARCH = 5;
    private String m_title;
    private int m_mode;
    private JPanel m_main;
    private FormAction m_action;
    private boolean m_cancel = false;

    public EasyForm(int mode) {
        this(mode, 15);
    }

    public EasyForm(int mode, int actionButtons) {
        super(new BorderLayout());
        UIManager.put("TextField.inactiveForeground", UIManager.getColor("TextField.foreground"));
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.m_mode = mode;
        this.defaultInit(actionButtons);
    }

    private void defaultInit(int actionButtons) {
        this.m_main = new JPanel(new GridBagLayout());
        this.add(this.m_main);
        this.m_action = new FormAction(this, actionButtons);
        this.add((Component)this.m_action, "South");
    }

    public void addField(String label, JComponent cmp, int x, int y, int w) {
        JLabel l = new JLabel(label);
        l.setLabelFor(cmp);
        this.addComponent(l, x, y, 1, 1);
        this.addComponent(cmp, x + 1, y, Math.max(w - 1, 1), 1);
    }

    public void addComponent(JComponent cmp, int x, int y) {
        this.addComponent(cmp, x, y, 1, 1);
    }

    public void addComponent(JComponent cmp, int x, int y, int w, int h) {
        this.m_main.add((Component)cmp, this.getConstraints(x, y, w, h));
    }

    private GridBagConstraints getConstraints(int x, int y, int w, int h) {
        return new GridBagConstraints(x, y, w, h, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public void performCancel() {
        this.m_cancel = true;
        this.close();
    }

    protected void close() {
        Container parent = this.getRootPane().getParent();
        if (parent instanceof JFrame) {
            ((JFrame)parent).dispose();
        } else if (parent instanceof JDialog) {
            ((JDialog)parent).dispose();
        } else if (parent instanceof JInternalFrame) {
            ((JInternalFrame)parent).dispose();
        } else {
            parent.setVisible(false);
        }
    }

    protected void handleException(Exception ex) {
        JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
    }

    public void performOk() {
        this.performApply();
        this.close();
    }

    public String getTitle() {
        return this.m_title;
    }

    protected void setTitle(int mode, String title) {
        String str = null;
        switch (mode) {
            case 0: {
                str = "<New> " + title;
                break;
            }
            default: {
                str = "" + title;
            }
        }
        this.m_title = str;
    }

    public void setEnabled(JComponent cmp, boolean b) {
        cmp.setEnabled(b);
        cmp.setOpaque(b);
    }

    public JPanel getMain() {
        return this.m_main;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public void performApply() {
    }

    public void performUndo() {
    }
}

