/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.brains2b.log.Logger;

public class UserPreference
extends Properties {
    public static final String DEFAULTPATH = System.getProperty("user.home") + "/.java/conf";
    private boolean m_dirty;
    private File m_file;

    public UserPreference(String filename) {
        this(new File(DEFAULTPATH, filename));
    }

    public UserPreference(File file) {
        this.m_file = System.getProperty("user.preference.file") != null ? new File(System.getProperty("user.preference.file")) : file;
        this.load();
    }

    public void load() {
        try {
            if (this.m_file.exists()) {
                FileInputStream fis = new FileInputStream(this.m_file);
                this.load(fis);
                this.setDirty(false);
            }
        }
        catch (IOException ioex) {
            Logger.printException(ioex);
            this.setDirty(true);
        }
    }

    public void store() {
        if (this.isDirty()) {
            try {
                this.checkDefaultPath();
                FileOutputStream fos = new FileOutputStream(this.m_file);
                this.store(fos, this.m_file.getCanonicalPath());
            }
            catch (IOException ioex) {
                Logger.printException(ioex);
            }
        }
    }

    public synchronized Object setProperty(String key, String value) {
        if (key == null || value == null) {
            return null;
        }
        String oldValue = super.getProperty(key);
        if (oldValue == null || !oldValue.equals(value)) {
            this.setDirty(true);
        }
        return super.put(key, value);
    }

    public void setDefault(String key, String defaultValue) {
        if (key == null || defaultValue == null) {
            return;
        }
        String oldValue = super.getProperty(key);
        if (oldValue == null) {
            super.put(key, defaultValue);
        }
    }

    public synchronized Object put(Object key, Object value) {
        this.setDirty(true);
        return super.put(key, value);
    }

    protected boolean isDirty() {
        return this.m_dirty;
    }

    protected void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    protected void setFile(File f) {
        this.m_file = f;
    }

    public String getFilename() {
        return this.m_file.getAbsolutePath();
    }

    private void checkDefaultPath() {
        if (DEFAULTPATH.equals(this.m_file.getParent()) && !this.m_file.getParentFile().exists() && !this.m_file.getParentFile().mkdirs()) {
            this.m_file = new File(this.m_file.getName());
        }
    }
}

