/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.action;

import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.brains2b.collection.SortedMap;
import org.brains2b.swingext.action.DefaultAction;
import org.brains2b.swingext.gui.IconFactory;

public class ExtActionMap
extends ActionMap {
    private ActionListener m_parent;
    private SortedMap m_map = new SortedMap();

    public ExtActionMap(ActionListener parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Cannot add null as ActionListener");
        }
        this.m_parent = parent;
    }

    public static final void setDefaultSystemActions(ExtActionMap map) {
        map.addAction("System.exit", "Exit", "Exit", null, "alt F4", 'x');
        map.addAction("System.preference", "Preferences", "Show preference dialog", null, null, 'p');
        map.addAction("Help.help", "Help", "Help", null, "F1", 'h');
        map.addAction("Help.about", "About", "About", null, null, 'a');
    }

    public void addAction(Object actionCommand, String label, String description, String icon, String accelerator, char mnemomic) {
        if (actionCommand == null) {
            throw new IllegalArgumentException("ActionCommandKey cannot be null");
        }
        KeyStroke key = null;
        if (accelerator != null) {
            key = KeyStroke.getKeyStroke(accelerator);
        }
        ImageIcon icn = null;
        if (icon != null) {
            String str = icon;
            if (icon.indexOf(47) == -1) {
                str = "/org/brains2b/images/" + icon;
            }
            try {
                icn = IconFactory.createIcon(str);
            }
            catch (NullPointerException npex) {
                icn = null;
            }
        }
        DefaultAction act = new DefaultAction(this.m_parent, actionCommand, label, description, icn, key, mnemomic);
        this.m_map.put(actionCommand, act);
    }

    public ActionListener getListener() {
        return this.m_parent;
    }

    public Object[] allKeys() {
        Object[] keys = this.keys();
        if (this.getParent() == null) {
            return keys;
        }
        Object[] parentKeys = this.getParent().allKeys();
        if (parentKeys == null || parentKeys.length == 0) {
            return keys;
        }
        Object[] outKeys = new Object[keys.length + parentKeys.length];
        System.arraycopy(parentKeys, 0, outKeys, keys.length, parentKeys.length);
        System.arraycopy(keys, 0, outKeys, 0, keys.length);
        return outKeys;
    }

    public void clear() {
        this.m_map.clear();
    }

    public Action get(Object key) {
        Action a = (Action)this.m_map.get(key);
        if (a == null && this.getParent() != null) {
            a = this.getParent().get(key);
        }
        return a;
    }

    public Object[] keys() {
        Set s = this.m_map.keySet();
        if (s.isEmpty()) {
            return null;
        }
        return s.toArray();
    }

    public void put(Object key, Action action) {
        this.m_map.put(key, action);
    }

    public void remove(Object key) {
        this.m_map.remove(key);
    }

    public int size() {
        return this.m_map.size();
    }

    public SortedMap getMap() {
        return this.m_map;
    }
}

