/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.event.SwingPropertyChangeSupport;

public class DefaultAction
implements Action {
    private Object[] m_array = new Object[0];
    private ActionListener m_listener;
    private SwingPropertyChangeSupport m_changeSupport;
    private boolean m_enabled = true;

    public DefaultAction(ActionListener listener) {
        this.m_listener = listener;
    }

    public DefaultAction(ActionListener listener, Object action) {
        this(listener);
        this.putValue("ActionCommandKey", action);
    }

    public DefaultAction(ActionListener listener, Object action, String label, String description, Icon icon, KeyStroke stroke, char mnemonic) {
        this(listener);
        this.putValue("ActionCommandKey", action);
        this.putValue("Name", label);
        this.putValue("ShortDescription", description);
        this.putValue("SmallIcon", icon);
        this.putValue("AcceleratorKey", stroke);
        this.putValue("MnemonicKey", new Integer(mnemonic));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_changeSupport == null) {
            this.m_changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.m_changeSupport.addPropertyChangeListener(listener);
    }

    public Object getValue(String key) {
        for (int i = 0; i < this.m_array.length; i += 2) {
            if (!key.equals(this.m_array[i])) continue;
            return this.m_array[i + 1];
        }
        return null;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void putValue(String key, Object value) {
        if (key == null) {
            return;
        }
        Object oldValue = this.getValue(key);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue == null) {
            int length = this.m_array.length;
            this.resize(length, 2);
            this.m_array[length] = key;
            this.m_array[length + 1] = value;
        } else {
            int idx = this.indexOf(key);
            if (value == null) {
                this.resize(idx, -2);
            } else {
                this.m_array[idx + 1] = value;
            }
        }
        this.firePropertyChanged(key, oldValue, value);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.m_changeSupport == null) {
            return;
        }
        this.m_changeSupport.removePropertyChangeListener(listener);
    }

    public void setEnabled(boolean b) {
        boolean oldValue = this.m_enabled;
        if (b != oldValue) {
            this.m_enabled = b;
            this.firePropertyChanged("enabled", oldValue, b);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.m_listener.actionPerformed(e);
    }

    private void firePropertyChanged(String key, Object oldValue, Object newValue) {
        if (this.m_changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.m_changeSupport.firePropertyChange(key, oldValue, newValue);
    }

    private final int indexOf(String key) {
        for (int i = 0; i < this.m_array.length; i += 2) {
            if (!key.equals(this.m_array[i])) continue;
            return i;
        }
        return -1;
    }

    private final void resize(int pos, int change) {
        int length = this.m_array.length;
        if (change < 0) {
            this.m_array[pos] = this.m_array[length + change];
            this.m_array[pos + 1] = this.m_array[length + change + 1];
        }
        Object[] tmp = new Object[length + change];
        System.arraycopy(this.m_array, 0, tmp, 0, change < 0 ? tmp.length : length);
        this.m_array = tmp;
    }
}

