/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

public final class StringHelper {
    private static final char[] LEFTQUOTE = new char[]{'\'', '\"', '{', '[', '('};
    private static final char[] RIGHTQUOTE = new char[]{'\'', '\"', '}', ']', ')'};

    protected StringHelper() {
    }

    public static String initCaps(String str, char c) {
        if (str == null) {
            return null;
        }
        char[] chr = str.toCharArray();
        for (int i = 0; i < chr.length; ++i) {
            if (i != 0 && chr[i - 1] != c) continue;
            chr[i] = Character.toUpperCase(chr[i]);
        }
        return String.valueOf(chr);
    }

    public static String stripper(String str, char c) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        str = str.trim();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == c) continue;
            stb.append(str.charAt(i));
        }
        return stb.toString();
    }

    public static int getNonBaseCharacter(String value) {
        return StringHelper.getNonBaseCharacter(value, 0);
    }

    public static int getNonBaseCharacter(String value, int start) {
        int idx = value.length();
        for (int i = start; i < value.length(); ++i) {
            if (Character.isLetterOrDigit(value.charAt(i))) continue;
            idx = i;
            break;
        }
        return idx;
    }

    public static String baseOnly(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        str = str.toUpperCase();
        for (int i = 0; i < str.length(); ++i) {
            if (!(str.charAt(i) >= 'A' & str.charAt(i) <= 'Z') && !(str.charAt(i) >= '0' & str.charAt(i) <= '9')) continue;
            stb.append(str.charAt(i));
        }
        return stb.toString();
    }

    public static final String breakLine(String str, int maxLen) {
        if (str == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer(str);
        int last = 0;
        String linebreak = System.getProperty("line.separator");
        int lbc = 0;
        for (int i = 0; i < stb.length(); ++i) {
            char ch = stb.charAt(i);
            if (ch == linebreak.charAt(lbc)) {
                if (lbc == linebreak.length() - 1) {
                    lbc = 0;
                    last = i;
                    continue;
                }
                ++lbc;
                continue;
            }
            if (i - last <= maxLen) continue;
            for (int j = 0; j < i - last; ++j) {
                switch (stb.charAt(i - j)) {
                    case ' ': 
                    case '!': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case ';': 
                    case '?': {
                        stb.insert(i - j + 1, linebreak);
                        last = i - j + 1;
                    }
                }
            }
        }
        return stb.toString();
    }

    public static String leftPad(String str, String filler, int len) {
        if (str == null) {
            str = new String();
        }
        if (filler == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (str.length() >= len) {
            return str.substring(str.length() - len);
        }
        StringBuffer stb = new StringBuffer(len);
        for (int i = 0; i < len - str.length(); i += filler.length()) {
            stb.insert(i, filler);
        }
        stb.append(str);
        return stb.toString();
    }

    public static String rightPad(String str, String filler, int len) {
        if (str == null) {
            str = new String();
        }
        if (filler == null) {
            throw new NullPointerException("filler cannot be null");
        }
        if (str.length() >= len) {
            return str.substring(0, len);
        }
        StringBuffer stb = new StringBuffer(len);
        stb.append(str);
        for (int i = 0; i < len - str.length(); ++i) {
            stb.append(filler);
        }
        return stb.toString();
    }

    public static int matchBracket(char left, String line) {
        int idx = line.indexOf(left);
        if (idx == -1) {
            return -1;
        }
        return StringHelper.matchBracket(idx, line);
    }

    public static int matchBracket(int pos, String line) {
        char begin = '\u0000';
        char end = '\u0000';
        int out = -1;
        if (pos == -1) {
            return pos;
        }
        for (int i = 0; i < LEFTQUOTE.length; ++i) {
            if (line.charAt(pos) != LEFTQUOTE[i]) continue;
            begin = LEFTQUOTE[i];
            end = RIGHTQUOTE[i];
            break;
        }
        if (begin == '\u0000' || end == '\u0000') {
            return -1;
        }
        int cnt = 0;
        for (int i = pos + 1; i < line.length(); ++i) {
            if (line.charAt(i) == begin) {
                if (begin == end) {
                    out = i;
                    break;
                }
                ++cnt;
            }
            if (line.charAt(i) != end) continue;
            if (cnt == 0) {
                out = i;
                break;
            }
            --cnt;
        }
        return out;
    }

    public static boolean isQuoteCharacter(char a) {
        return a == '\'' || a == '\"';
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

