/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.brains2b.util.StringHelper;

public class DateHelper {
    private static final Calendar m_cal = Calendar.getInstance();
    private static final int THIS_YEAR = m_cal.get(1);
    private static final Locale m_locale = Locale.getDefault();
    private static final String DEFAULT_DATE = "dd-MMM-yyyy";
    private static final String ISO_DATE = "yyyy-MM-dd";
    private static final String ISO_COMPLETE = "yyyy-MM-dd'T'HH:mm:ss.S";
    private static ThreadSafeDateFormat m_sdf = new ThreadSafeDateFormat();

    public static final String fromDate(Date dt) {
        if (dt == null) {
            return null;
        }
        ((SimpleDateFormat)m_sdf.get()).applyPattern(DEFAULT_DATE);
        return ((SimpleDateFormat)m_sdf.get()).format(dt);
    }

    public static final Date toDate(String txt) throws NumberFormatException {
        return DateHelper.toDate(txt, m_locale);
    }

    public static final Date toDate(String txt, Locale locale) throws NumberFormatException {
        boolean HH = false;
        boolean MM = false;
        boolean SS = false;
        int dd = 0;
        int mm = -1;
        int yy = 0;
        boolean full_year = false;
        if (txt.length() == 6 && StringHelper.baseOnly(txt).length() == 6 || txt.length() == 8 && StringHelper.baseOnly(txt).length() == 8) {
            if (m_locale.equals(Locale.US)) {
                mm = Integer.parseInt(txt.substring(0, 2)) - 1;
                dd = Integer.parseInt(txt.substring(2, 4));
            } else {
                dd = Integer.parseInt(txt.substring(0, 2));
                mm = Integer.parseInt(txt.substring(2, 4)) - 1;
            }
            full_year = txt.length() - 4 == 4;
            yy = Integer.parseInt(txt.substring(4));
        } else {
            int pos = 0;
            for (int i = 0; i < txt.length(); ++i) {
                if (Character.isLetterOrDigit(txt.charAt(i)) || "fr".equals(locale.getLanguage()) && txt.charAt(i) == '.') continue;
                if (pos == 0) {
                    dd = Integer.parseInt(txt.substring(pos, i));
                    pos = i + 1;
                    continue;
                }
                mm = DateHelper.getMonth(txt.substring(pos, i), locale);
                pos = i + 1;
            }
            full_year = txt.length() - pos == 4;
            yy = Integer.parseInt(txt.substring(pos));
        }
        if (dd > 0 & mm >= 0 & yy > 0) {
            try {
                if (yy < 100 && !full_year) {
                    yy += THIS_YEAR / 100 * 100;
                }
                m_cal.setLenient(false);
                m_cal.set(yy, mm, dd, 0, 0, 0);
                m_cal.set(14, 0);
                return m_cal.getTime();
            }
            catch (IllegalArgumentException iaex) {
                // empty catch block
            }
        }
        throw new NumberFormatException("Not a valid date");
    }

    public static final String isoFromDate(Date d, boolean includeTime) {
        ((SimpleDateFormat)m_sdf.get()).applyPattern(includeTime ? ISO_COMPLETE : ISO_DATE);
        String t = ((SimpleDateFormat)m_sdf.get()).format(d);
        return t;
    }

    public static final String isoFromDate(Date d) {
        return DateHelper.isoFromDate(d, false);
    }

    public static final Date isoToDate(String s) {
        if (s == null) {
            return null;
        }
        try {
            int idx = s.indexOf(84);
            boolean includeTime = idx > 0 && s.charAt(idx + 3) == ':';
            ((SimpleDateFormat)m_sdf.get()).applyPattern(includeTime ? ISO_COMPLETE : ISO_DATE);
            return ((SimpleDateFormat)m_sdf.get()).parse(s);
        }
        catch (ParseException pex) {
            throw new NumberFormatException("Not a valid date");
        }
    }

    public static final int betweenDate(Date d1, Date d2, int field, boolean round) {
        if (d1 == null || d2 == null) {
            throw new IllegalArgumentException("Both dates need to be provided to calculate difference");
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        return DateHelper.betweenDate(c1, c2, field, round);
    }

    public static final int betweenDate(Calendar c1, Calendar c2, int field, boolean round) {
        if (c1 == null || c2 == null) {
            throw new IllegalArgumentException("Both calendars need to be provided to calculate difference");
        }
        double result = 0.0;
        switch (field) {
            case 1: {
                result = c2.get(1) - c1.get(1);
                if (!round) break;
                result += (double)(c2.get(6) * c1.getActualMaximum(6) - c1.get(6) * c2.getActualMaximum(6)) / (double)(c2.getActualMaximum(6) * c1.getActualMaximum(6));
                break;
            }
            case 2: {
                result = c2.get(2) - c1.get(2);
                result += (double)DateHelper.getYearDiff(c1, c2, 2);
                if (!round) break;
                result += (double)(c2.get(5) * c1.getActualMaximum(5) - c1.get(5) * c2.getActualMaximum(5)) / (double)(c2.getActualMaximum(5) * c1.getActualMaximum(5));
                break;
            }
            case 5: 
            case 6: {
                result = c2.get(6) - c1.get(6);
                result += (double)DateHelper.getYearDiff(c1, c2, 6);
                if (!round) break;
                result += (double)(c2.get(11) * c1.getActualMaximum(11) - c1.get(11) * c2.getActualMaximum(11)) / (double)(c2.getActualMaximum(11) * c1.getActualMaximum(11));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot determine difference for the supplied field");
            }
        }
        return (int)Math.round(result);
    }

    private static final int getYearDiff(Calendar c1, Calendar c2, int field) {
        int result = 0;
        int start = c1.get(1);
        int end = c2.get(1);
        Calendar clone = (Calendar)c1.clone();
        if (start > end) {
            start = end;
            end = c1.get(1);
            clone = (Calendar)c2.clone();
        }
        for (int i = start; i < end; ++i) {
            result += clone.getActualMaximum(field);
            clone.set(1, i);
        }
        return result;
    }

    private static int getMonth(String str, Locale locale) {
        int mm = 0;
        try {
            mm = Integer.parseInt(str) - 1;
            return mm;
        }
        catch (NumberFormatException ex) {
            DateFormatSymbols symb = new DateFormatSymbols(locale);
            if (str.length() > 3 && !"fr".equals(locale.getLanguage()) || "fr".equals(locale.getLanguage()) && !str.endsWith(".")) {
                String[] months = symb.getMonths();
                for (int i = 0; i < months.length; ++i) {
                    if (!str.equalsIgnoreCase(months[i])) continue;
                    return i;
                }
            } else {
                String[] months = symb.getShortMonths();
                for (int i = 0; i < months.length; ++i) {
                    if (!str.equalsIgnoreCase(months[i])) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    static class ThreadSafeDateFormat
    extends ThreadLocal {
        ThreadSafeDateFormat() {
        }

        protected Object initialValue() {
            return new SimpleDateFormat();
        }
    }
}

