/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class Logger
extends java.util.logging.Logger {
    public static final int PANIC = 0;
    public static final int INFO = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 4;
    public static final int TRACE = 8;
    public static final int DEBUG = 16;
    public static final int DEBUG_VERBOSE = 32;
    private static Logger m_instance;

    protected Logger(String name, String resourceBundle) {
        super(name, resourceBundle);
        this.setLevel(Level.INFO);
        this.findFile();
        this.findSystemProperties();
    }

    protected static Logger instance() {
        if (m_instance == null) {
            m_instance = new Logger("twelbox", null);
        }
        return m_instance;
    }

    public static Logger getLogger() {
        return Logger.instance();
    }

    public static void setLevel(int level) {
        Logger.instance().setLevel(Logger.instance().getLevel(level));
    }

    public static void println(String str) {
        Logger.instance().log(Level.INFO, str);
    }

    public static void print(Object o) {
        if (o == null) {
            o = "null";
        }
        Logger.instance().log(Level.INFO, o.toString());
    }

    public static void println(String str, int level) {
        Level l = Logger.instance().getLevel(level);
        Logger.instance().log(l, str);
    }

    public static void print(Object o, int level) {
        if (o == null) {
            o = "null";
        }
        Level l = Logger.instance().getLevel(level);
        Logger.instance().log(l, o.toString());
    }

    public static void printException(String message, Exception ex) {
        if (Logger.instance().isLoggable(Level.CONFIG)) {
            Logger.instance().log(Level.SEVERE, message, ex);
        } else {
            Logger.instance().log(Level.SEVERE, message);
        }
    }

    public static void printException(Exception ex) {
        Logger.printException(ex.getMessage(), ex);
    }

    private void init(Properties prop) {
        StreamHandler sh;
        FileHandler fh;
        String value = prop.getProperty("logger.level");
        int level = 1;
        if (value != null) {
            if ("TRACE".equalsIgnoreCase(value)) {
                level = 8;
            }
            if ("DEBUG".equalsIgnoreCase(value)) {
                level = 16;
            }
            if ("DEBUG_VERBOSE".equalsIgnoreCase(value)) {
                level = 32;
            }
            if ("WARNING".equalsIgnoreCase(value)) {
                level = 4;
            }
            if ("ERROR".equalsIgnoreCase(value)) {
                level = 2;
            }
        }
        this.setLevel(this.getLevel(level));
        value = prop.getProperty("logger.err.out");
        if (value != null) {
            try {
                fh = new FileHandler(value, true);
                fh.setLevel(Level.SEVERE);
                fh.setFormatter(new ClassicFormatter());
                this.addHandler(fh);
            }
            catch (IOException iex) {
                value = null;
            }
        }
        if (value == null) {
            sh = new ConsoleHandler();
            sh.setLevel(Level.SEVERE);
            sh.setFormatter(new ClassicFormatter());
            this.addHandler(sh);
        }
        if ((value = prop.getProperty("logger.std.out")) != null) {
            try {
                fh = new FileHandler(value, true);
                fh.setFormatter(new ClassicFormatter());
                fh.setLevel(Level.FINEST);
                fh.setFilter(new Filter(){

                    public boolean isLoggable(LogRecord record) {
                        return record.getLevel() != Level.SEVERE;
                    }
                });
                this.addHandler(fh);
            }
            catch (IOException iex) {
                value = null;
            }
        }
        if (value == null) {
            sh = new StreamHandler(System.out, new ClassicFormatter()){

                public synchronized void publish(LogRecord record) {
                    super.publish(record);
                    this.flush();
                }
            };
            sh.setLevel(Level.FINEST);
            sh.setFilter(new Filter(){

                public boolean isLoggable(LogRecord record) {
                    return record.getLevel() != Level.SEVERE;
                }
            });
            this.addHandler(sh);
        }
    }

    private void findFile() {
        try {
            File fl = new File("logger.properties");
            if (!fl.exists()) {
                fl = new File("conf/logger.properties");
            }
            if (fl.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(fl));
                this.init(prop);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void findSystemProperties() {
        this.init(System.getProperties());
    }

    private final Level getLevel(int level) {
        switch (level) {
            case 0: 
            case 2: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.WARNING;
            }
            case 8: {
                return Level.CONFIG;
            }
            case 16: {
                return Level.FINE;
            }
            case 32: {
                return Level.FINEST;
            }
        }
        return Level.INFO;
    }

    public static class ClassicFormatter
    extends Formatter {
        public String format(LogRecord record) {
            String format = "";
            if (record.getLevel() == Level.SEVERE) {
                format = "[  error  ] ";
            } else if (record.getLevel() == Level.WARNING) {
                format = "[ warning ] ";
            }
            if (record.getThrown() == null) {
                return format + record.getMessage() + "\n";
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(format + record.getMessage());
            pw.println("********************* [Stack Trace] ******************");
            record.getThrown().printStackTrace(pw);
            pw.println("********************* [End Trace] ******************");
            pw.flush();
            return sw.toString();
        }
    }
}

