/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.preference;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.brains2b.collection.EntryImpl;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.fontchooser.FontChooserPane;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;
import org.brains2b.swingext.gui.IconFactory;
import org.brains2b.swingext.util.FontHelper;
import org.brains2b.util.GuiHelper;
import org.brains2b.util.StringHelper;

public class PreferencePane
extends JPanel
implements Form {
    private static final int CHECKBOX = 1;
    private static final int COMBOBOX = 2;
    public static final int COLOR = 3;
    public static final int FONT = 4;
    private static final int FIELD = 5;
    public static final int FILE = 6;
    public static final int LIST = 7;
    private JComponent mMain;
    private ResourceBundle m_resource;
    private TreeSet m_changed;
    private ValueChanged mValueChanged;
    private Properties m_prop;
    private ActionEventHandler mAeh;
    private HashMap propertyType = new HashMap();
    private boolean m_autoTab;
    private HashMap m_tabs;
    private ArrayList m_ignore;
    private ImageIcon fileIcon;
    private ImageIcon plusIcon;
    private ImageIcon minusIcon;
    private HashMap m_options;

    public PreferencePane(Properties prop) {
        this.m_prop = prop;
    }

    protected void initValues() {
        Set<Object> s = this.m_prop.keySet();
        TreeSet<Object> ts = new TreeSet<Object>(s);
        if (ts.isEmpty()) {
            ts.addAll(this.m_options.keySet());
            ts.addAll(this.propertyType.keySet());
        }
        if (this.isAutoTab()) {
            this.makeTabs(ts);
        }
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        pnl.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 3, 1, 3);
        boolean componentSet = false;
        for (String string : ts) {
            if (this.isIgnorePattern(string)) continue;
            int idx = string.indexOf(46);
            if (this.m_tabs != null && (this.m_tabs == null || idx == -1 || this.m_tabs.containsKey(string.substring(0, idx)))) continue;
            String string2 = this.getResourceValue(string, string);
            this.setComponent(pnl, gbc, string, this.m_prop.getProperty(string), string2);
            componentSet = true;
        }
        if (this.m_tabs == null || this.m_tabs.isEmpty()) {
            this.mMain = pnl;
        } else if (componentSet) {
            this.addTabPane(pnl, this.getResourceValue("Preference.generalTitle", "General"), null);
        }
        if (this.m_tabs != null && !this.m_tabs.isEmpty()) {
            for (String tabKey : this.m_tabs.keySet()) {
                pnl = new JPanel();
                pnl.setLayout(new GridBagLayout());
                pnl.setBorder(new EmptyBorder(5, 5, 5, 5));
                gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.anchor = 17;
                gbc.insets = new Insets(1, 3, 1, 3);
                for (String string : ts) {
                    int idx;
                    if (this.isIgnorePattern(string) || (idx = string.indexOf(46)) == -1 || !tabKey.equals(string.substring(0, idx))) continue;
                    String label = this.getResourceValue(string, string);
                    this.setComponent(pnl, gbc, string, this.m_prop.getProperty(string), label);
                }
                this.addTabPane(pnl, (String)this.m_tabs.get(tabKey), null);
            }
        }
    }

    private JComponent findComponent(String name) {
        return this.findComponent(this.mMain, name);
    }

    private JComponent findComponent(Container root, String name) {
        JComponent cmp = null;
        Component[] cmps = root.getComponents();
        for (int i = 0; i < cmps.length; ++i) {
            if (cmps[i] instanceof JPanel && !name.equals(cmps[i].getName())) {
                cmp = this.findComponent((JPanel)cmps[i], name);
                if (cmp == null) continue;
                break;
            }
            if (cmps[i] instanceof JScrollPane && name.equals(((JScrollPane)cmps[i]).getViewport().getView().getName())) {
                cmp = (JComponent)((JScrollPane)cmps[i]).getViewport().getView();
                continue;
            }
            if (!name.equals(cmps[i].getName())) continue;
            cmp = (JComponent)cmps[i];
            break;
        }
        return cmp;
    }

    private String getValue(JComponent cmp) {
        String value = null;
        if (cmp instanceof JTextField) {
            value = ((JTextField)cmp).getText();
        } else if (cmp instanceof JCheckBox) {
            value = String.valueOf(((JCheckBox)cmp).isSelected());
        } else if (cmp instanceof JButton) {
            JButton b = (JButton)cmp;
            value = b.getActionCommand().equals("font") ? FontHelper.encode(b.getFont()) : String.valueOf(((ColorIcon)b.getIcon()).color.getRGB());
        } else if (cmp instanceof JList) {
            value = this.getString(((DefaultListModel)((JList)cmp).getModel()).toArray());
        } else if (cmp instanceof JComboBox) {
            value = ((EntryImpl)((JComboBox)cmp).getSelectedItem()).getKey();
        }
        return value;
    }

    private String getValue(String key) {
        return this.getValue(this.findComponent(key));
    }

    private void setProperties() {
        if (!this.m_changed.isEmpty()) {
            for (String key : this.m_changed) {
                this.m_prop.put(key, this.getValue(key));
            }
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.mValueChanged = new ValueChanged();
        this.mMain = new JTabbedPane(1);
        this.mMain.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.mAeh = new ActionEventHandler();
        this.fileIcon = IconFactory.createIcon("/org/brains2b/images/Open16.gif");
        this.plusIcon = IconFactory.createIcon("/org/brains2b/images/Plus16.gif");
        this.minusIcon = IconFactory.createIcon("/org/brains2b/images/Minus16.gif");
        this.m_changed = new TreeSet();
        this.initValues();
        this.add((Component)this.mMain, "Center");
        if (this.m_resource != null) {
            this.add((Component)new FormAction(this, 7, this.m_resource), "South");
        } else {
            this.add((Component)new FormAction(this, 3), "South");
        }
    }

    public void performApply() {
        this.setProperties();
    }

    public void performOk() {
        this.setProperties();
        this.close();
    }

    public void performUndo() {
        this.mMain.removeAll();
        this.initValues();
        this.validate();
    }

    public void performCancel() {
        this.close();
    }

    private void close() {
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).doDefaultCloseAction();
        } else {
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }

    protected void addTabPane(JPanel pnl, String title, Icon icon) {
        ((JTabbedPane)this.mMain).addTab(title, icon, pnl);
    }

    protected void setComponent(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        switch (this.getComponentType(key, value)) {
            case 1: {
                this.setCheckBox(p, gbc, key, value, label);
                break;
            }
            case 3: {
                this.setColorPanel(p, gbc, key, value, label);
                break;
            }
            case 4: {
                this.setFontPanel(p, gbc, key, value, label);
                break;
            }
            case 2: {
                this.setComboBox(p, gbc, key, value, label);
                break;
            }
            case 6: {
                this.setFilePanel(p, gbc, key, value, label);
                break;
            }
            case 7: {
                this.setListPanel(p, gbc, key, value, label);
                break;
            }
            default: {
                this.setTextField(p, gbc, key, value, label);
            }
        }
    }

    protected void setTextField(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JLabel lbl = new JLabel(label);
        lbl.setForeground(Color.black);
        JTextField fld = new JTextField();
        fld.setName(key);
        if (value != null && value.length() > 0) {
            fld.setColumns(value.length() + 3);
        } else {
            fld.setColumns(10);
        }
        fld.addCaretListener(this.mValueChanged);
        fld.setName(key);
        fld.setText(value);
        lbl.setLabelFor(fld);
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        p.add((Component)fld, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
    }

    protected void setColorPanel(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JLabel lbl = new JLabel(label);
        JButton btn = new JButton();
        Color c = Color.white;
        if (!StringHelper.isEmpty(value)) {
            c = Color.decode(value);
        }
        btn.setIcon(new ColorIcon(c));
        btn.setName(key);
        btn.addActionListener(this.mAeh);
        btn.setActionCommand("color");
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        p.add((Component)btn, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
    }

    protected void setFilePanel(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JLabel lbl = new JLabel(label);
        JTextField file = new JTextField();
        file.setColumns(32);
        file.setBorder(new BevelBorder(1));
        file.setText(value);
        file.addCaretListener(new ValueChanged());
        file.setName(key);
        JButton btn = new JButton(this.fileIcon);
        btn.addActionListener(this.mAeh);
        btn.setName(key);
        btn.setActionCommand("file");
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        p.add((Component)file, gbc);
        gbc.gridx = 2;
        p.add((Component)btn, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
    }

    protected void setListPanel(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout());
        JLabel lbl = new JLabel(label);
        JTextField entry = new JTextField();
        entry.setBorder(new BevelBorder(1));
        JList list = new JList();
        DefaultListModel<String> model = new DefaultListModel<String>();
        list.setModel(model);
        list.setMinimumSize(new Dimension(80, 40));
        list.setName(key);
        list.setPrototypeCellValue(StringHelper.leftPad("M", "M", 16));
        list.setVisibleRowCount(5);
        list.setSelectionMode(0);
        if (value != null) {
            String[] items = PreferencePane.getList(value);
            for (int i = 0; i < items.length; ++i) {
                model.addElement(items[i]);
            }
        }
        JScrollPane scroll = new JScrollPane(list);
        JButton add = new JButton(this.plusIcon);
        add.putClientProperty("field", entry);
        add.putClientProperty("list", list);
        add.addActionListener(this.mAeh);
        add.setActionCommand("listadd");
        JButton remove = new JButton(this.minusIcon);
        remove.putClientProperty("list", list);
        remove.addActionListener(this.mAeh);
        remove.setActionCommand("listremove");
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        p.add((Component)entry, gbc);
        gbc.fill = 0;
        gbc.gridx = 2;
        p.add((Component)add, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        gbc.fill = 2;
        p.add((Component)scroll, gbc);
        gbc.fill = 0;
        gbc.gridx = 2;
        gbc.anchor = 18;
        p.add((Component)remove, gbc);
        gbc.anchor = 17;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
    }

    protected void setFontPanel(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JLabel lbl = new JLabel(label);
        JButton btn = new JButton();
        btn.setFont(Font.decode(value));
        btn.setText(value);
        btn.setName(key);
        btn.addActionListener(this.mAeh);
        btn.setActionCommand("font");
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        gbc.fill = 1;
        p.add((Component)btn, gbc);
        gbc.fill = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
    }

    protected void setCheckBox(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JCheckBox chk = new JCheckBox();
        chk.setName(key);
        chk.setText(label);
        chk.setSelected(new Boolean(value));
        chk.addChangeListener(this.mValueChanged);
        chk.setName(key);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        p.add((Component)chk, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
    }

    protected void setComboBox(JPanel p, GridBagConstraints gbc, String key, String value, String label) {
        JComboBox<Object> cmb = new JComboBox<Object>(((List)this.m_options.get(key)).toArray());
        JLabel lbl = new JLabel(label);
        lbl.setForeground(Color.black);
        cmb.addActionListener(this.mValueChanged);
        cmb.setName(key);
        for (int i = 0; i < cmb.getItemCount(); ++i) {
            if (!cmb.getItemAt(i).equals(value)) continue;
            cmb.setSelectedIndex(i);
            break;
        }
        lbl.setLabelFor(cmb);
        p.add((Component)lbl, gbc);
        gbc.gridx = 1;
        p.add(cmb, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
    }

    private int getComponentType(String key, String value) {
        int result = 0;
        if (this.propertyType.containsKey(key)) {
            result = (Integer)this.propertyType.get(key);
        } else if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            result = 1;
        } else if (this.keyHasOptions(key)) {
            result = 2;
        } else if (key.toLowerCase().indexOf("font") != -1 && GuiHelper.isFont(value)) {
            result = 4;
        } else if (key.toLowerCase().indexOf("color") != -1 && GuiHelper.isColor(value)) {
            result = 3;
        } else if (value.indexOf(System.getProperty("file.separator")) != -1) {
            result = 6;
        }
        return result;
    }

    private boolean keyHasOptions(String key) {
        return this.m_options != null && this.m_options.get(key) != null;
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
        if ("ancestor".equals(propertyName) && oldValue == null) {
            this.init();
        }
    }

    public boolean isChanged() {
        return !this.m_changed.isEmpty();
    }

    private void openColorChooser(JComponent c) {
        JButton target = (JButton)this.getTarget(c);
        Color color = JColorChooser.showDialog(this, "Pick a color", target.getBackground());
        if (color != null) {
            target.setIcon(new ColorIcon(color));
            this.m_changed.add(target.getName());
        }
    }

    private void openFontChooser(JComponent c) {
        JButton target = (JButton)this.getTarget(c);
        Font f = FontChooserPane.showDialog(this, target.getFont(), "Pick a font");
        if (f != null) {
            target.setFont(f);
            target.setText(FontHelper.encode(f));
            this.m_changed.add(target.getName());
        }
    }

    private void openFileChooser(JComponent c) {
        File f;
        JTextField target = (JTextField)this._getTarget(c);
        JFileChooser jfc = new JFileChooser();
        if (target.getText() != null && (f = new File(target.getText())).exists()) {
            jfc.setCurrentDirectory(f);
        }
        jfc.setFileSelectionMode(2);
        jfc.showOpenDialog(target);
        f = jfc.getSelectedFile();
        if (f != null) {
            target.setText(f.getAbsolutePath());
            this.m_changed.add(target.getName());
        }
    }

    private Component getTarget(JComponent c) {
        if (c.getClientProperty("target") == null) {
            return c;
        }
        return (JComponent)c.getClientProperty("target");
    }

    private Component _getTarget(JComponent c) {
        Container parent = c.getParent();
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component child = parent.getComponent(i);
            if (child == null || c.equals(child) || !c.getName().equals(child.getName())) continue;
            return child;
        }
        return null;
    }

    public void setIgnorePattern(String pattern) {
        if (this.m_ignore == null) {
            this.m_ignore = new ArrayList();
        } else {
            this.m_ignore.clear();
        }
        this.m_ignore.add(pattern);
    }

    public void addIgnorePattern(String pattern) {
        if (this.m_ignore == null) {
            this.m_ignore = new ArrayList();
        }
        this.m_ignore.add(pattern);
    }

    private boolean isIgnorePattern(String key) {
        if (this.m_ignore == null) {
            return false;
        }
        Iterator it = this.m_ignore.iterator();
        while (it.hasNext()) {
            if (key.indexOf((String)it.next()) == -1) continue;
            return true;
        }
        return false;
    }

    public void setPropertyType(String key, int type) {
        this.propertyType.put(key, new Integer(type));
    }

    public void setOptionsFor(String key, Map t) {
        if (this.m_options == null) {
            this.m_options = new HashMap();
        }
        ArrayList<EntryImpl> v = new ArrayList<EntryImpl>();
        for (String itm : t.keySet()) {
            v.add(new EntryImpl(itm, (String)t.get(itm)));
        }
        this.m_options.put(key, v);
    }

    public void setOptionsFor(String key, String[] options) {
        if (this.m_options == null) {
            this.m_options = new HashMap();
        }
        ArrayList<EntryImpl> v = new ArrayList<EntryImpl>();
        for (int i = 0; i < options.length; ++i) {
            v.add(new EntryImpl(options[i], options[i]));
        }
        this.m_options.put(key, v);
    }

    public void setOptionsFor(String key, String[][] options) {
        if (this.m_options == null) {
            this.m_options = new HashMap();
        }
        ArrayList<EntryImpl> v = new ArrayList<EntryImpl>();
        for (int i = 0; i < options.length; ++i) {
            v.add(new EntryImpl(options[i][0], options[i][1]));
        }
        this.m_options.put(key, v);
    }

    public void registerResourceBundle(ResourceBundle resource) {
        this.m_resource = resource;
    }

    protected String getResourceValue(String key, String defaultValue) {
        String label = defaultValue;
        if (this.m_resource != null) {
            try {
                label = this.m_resource.getString(key);
            }
            catch (MissingResourceException mrex) {
                // empty catch block
            }
        }
        return label;
    }

    public static final String[] getList(String s) {
        if (s == null) {
            return null;
        }
        StringTokenizer t = new StringTokenizer(s, ";");
        ArrayList<String> v = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            v.add(t.nextToken().trim());
        }
        String[] list = new String[v.size()];
        v.toArray(list);
        return list;
    }

    private String getString(Object[] list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append("; ");
            }
            sb.append(list[i]);
        }
        return sb.toString();
    }

    public boolean isAutoTab() {
        return this.m_autoTab;
    }

    public void setAutoTab(boolean b) {
        this.m_autoTab = b;
    }

    public void addTab(String forPrefix, String label) {
        if (this.m_tabs == null) {
            this.m_tabs = new HashMap();
        }
        this.m_tabs.put(forPrefix, label);
    }

    protected void makeTabs(TreeSet s) {
        if (this.m_tabs == null) {
            this.m_tabs = new HashMap();
        }
        Iterator it = s.iterator();
        while (it.hasNext()) {
            String key;
            int idx = (key = (String)it.next()).indexOf(".");
            String tabKey = key.substring(0, idx == -1 ? key.length() : idx);
            if (idx == -1 || this.m_tabs == null || this.m_tabs.containsKey(tabKey) || this.m_ignore.contains(tabKey)) continue;
            this.m_tabs.put(tabKey, tabKey);
        }
    }

    public static Properties showDialog(Component parent, Properties p) {
        PreferencePane pane = new PreferencePane(p);
        DialogHelper.showDialog(parent, pane, "Connections");
        return p;
    }

    public static Properties showInternalDialog(Component parent, Properties p, String title, Icon icon) {
        PreferencePane pane = new PreferencePane(p);
        DialogHelper.showInternalDialog(parent, pane, title, icon);
        return p;
    }

    private class ValueChanged
    implements CaretListener,
    ChangeListener,
    ActionListener {
        private ValueChanged() {
        }

        public void caretUpdate(CaretEvent e) {
            try {
                JComponent comp = (JComponent)e.getSource();
                if (!PreferencePane.this.m_prop.getProperty(comp.getName()).equals(PreferencePane.this.getValue(comp))) {
                    PreferencePane.this.m_changed.add(comp.getName());
                } else {
                    PreferencePane.this.m_changed.remove(comp.getName());
                }
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }

        public void stateChanged(ChangeEvent e) {
            try {
                JComponent comp = (JComponent)e.getSource();
                if (!PreferencePane.this.m_prop.getProperty(comp.getName()).equals(PreferencePane.this.getValue(comp))) {
                    PreferencePane.this.m_changed.add(comp.getName());
                } else {
                    PreferencePane.this.m_changed.remove(comp.getName());
                }
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JComponent comp = (JComponent)e.getSource();
                if (!PreferencePane.this.m_prop.getProperty(comp.getName()).equals(PreferencePane.this.getValue(comp))) {
                    PreferencePane.this.m_changed.add(comp.getName());
                } else {
                    PreferencePane.this.m_changed.remove(comp.getName());
                }
            }
            catch (Exception pe) {
                pe.printStackTrace();
            }
        }
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("color")) {
                PreferencePane.this.openColorChooser((JComponent)e.getSource());
            } else if (e.getActionCommand().equals("font")) {
                PreferencePane.this.openFontChooser((JComponent)e.getSource());
            } else if (e.getActionCommand().equals("file")) {
                PreferencePane.this.openFileChooser((JComponent)e.getSource());
            } else if (e.getActionCommand().equals("listadd")) {
                JButton b = (JButton)e.getSource();
                JTextField fld = (JTextField)b.getClientProperty("field");
                JList list = (JList)b.getClientProperty("list");
                ((DefaultListModel)list.getModel()).addElement(fld.getText());
                fld.setText("");
                PreferencePane.this.m_changed.add(list.getName());
            } else if (e.getActionCommand().equals("listremove")) {
                JButton b = (JButton)e.getSource();
                JList list = (JList)b.getClientProperty("list");
                ((DefaultListModel)list.getModel()).remove(list.getSelectedIndex());
                PreferencePane.this.m_changed.add(list.getName());
            }
        }
    }

    private class ColorIcon
    extends ImageIcon {
        public static final int WIDTH = 64;
        public static final int HEIGHT = 16;
        public Color color;

        public ColorIcon(Color c) {
            this.color = c;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 64;
        }

        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 64, 16);
        }
    }
}

