/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.fontchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;

public class FontChooserPane
extends JPanel
implements Form {
    private JList listFont;
    private JList listStyle;
    private JList listSize;
    private JLabel lblExample;
    private Font mFont;

    public FontChooserPane() {
        this((Font)null);
    }

    public FontChooserPane(Font f) {
        this.mFont = f;
        this.init();
    }

    public static Font showDialog(Component parent, Font f, String title) {
        FontChooserPane fc = new FontChooserPane(f);
        DialogHelper.showDialog(parent, fc, title);
        return fc.getResult();
    }

    public static Font showInternalDialog(Component parent, Font f, String title) {
        FontChooserPane fc = new FontChooserPane(f);
        DialogHelper.showInternalDialog(parent, fc, title, null);
        return fc.getResult();
    }

    private void init() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        SelectEventHandler seh = new SelectEventHandler();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.listFont = new JList();
        this.listFont.setListData(ge.getAvailableFontFamilyNames());
        this.listFont.addListSelectionListener(seh);
        JScrollPane pnlFont = new JScrollPane(this.listFont);
        pnlFont.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "Font: "), BorderFactory.createBevelBorder(1)));
        this.listStyle = new JList<String>(new String[]{"Plain", "Italic", "Bold", "Bold Italic"});
        this.listStyle.addListSelectionListener(seh);
        JScrollPane pnlStyle = new JScrollPane();
        pnlStyle.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "Style: "), BorderFactory.createBevelBorder(1)));
        pnlStyle.setViewportView(this.listStyle);
        this.listSize = new JList<String>(new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "48", "72"});
        this.listSize.setFixedCellWidth(3 * this.listSize.getFont().getSize());
        this.listSize.addListSelectionListener(seh);
        JScrollPane pnlSize = new JScrollPane();
        pnlSize.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "Size: "), BorderFactory.createBevelBorder(1)));
        pnlSize.setViewportView(this.listSize);
        JPanel pnlMain = new JPanel();
        pnlMain.setLayout(new BoxLayout(pnlMain, 0));
        pnlMain.add(pnlFont);
        pnlMain.add(pnlStyle);
        pnlMain.add(pnlSize);
        JPanel pnl = new JPanel();
        this.lblExample = new JLabel("AbCdEfGhiJkLmNoPqRsTuVwXyZ ");
        this.lblExample.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10), "Example: "), BorderFactory.createBevelBorder(1)));
        this.lblExample.setForeground(Color.black);
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)pnlMain, "Center");
        pnl.add((Component)this.lblExample, "South");
        this.add((Component)pnl, "Center");
        this.add((Component)new FormAction(this, 11), "South");
        this.setSelectedFont(this.mFont);
    }

    public Font getResult() {
        return this.mFont;
    }

    private Font getSelectedFont() {
        Font f = null;
        try {
            String name = (String)this.listFont.getSelectedValue();
            int style = this.getStyle(this.listStyle.getSelectedIndex());
            String s_size = (String)this.listSize.getSelectedValue();
            if (s_size == null) {
                s_size = "10";
            }
            int size = Integer.parseInt(s_size);
            f = new Font(name, style, size);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null) {
            f = this.mFont;
        }
        return f;
    }

    private void setSelectedFont(Font f) {
        if (f == null) {
            this.listFont.setSelectedIndex(0);
            this.listStyle.setSelectedIndex(0);
            this.listSize.setSelectedIndex(0);
        } else {
            this.listFont.setSelectedValue(f.getName(), true);
            this.listStyle.setSelectedIndex(this.getIndex(f.getStyle()));
            this.listSize.setSelectedValue(String.valueOf(f.getSize()), true);
        }
        this.updateExample(f);
    }

    private int getStyle(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private int getIndex(int style) {
        switch (style) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private void updateExample(Font f) {
        this.lblExample.setFont(f);
        this.lblExample.repaint();
    }

    public void performApply() {
        this.performOk();
    }

    public void performOk() {
        this.mFont = this.getSelectedFont();
        this.close();
    }

    public void performUndo() {
        this.setSelectedFont(this.mFont);
    }

    public void performCancel() {
        this.mFont = null;
        this.close();
    }

    private void close() {
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).doDefaultCloseAction();
        } else {
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }

    private class SelectEventHandler
    implements ListSelectionListener {
        private SelectEventHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            FontChooserPane.this.updateExample(FontChooserPane.this.getSelectedFont());
        }
    }
}

