/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;

public class EditorPane
extends JPanel
implements Form {
    private JTextComponent m_txtComp;
    private JTextPane m_textArea;
    private int maxLength = -1;

    public EditorPane(JTextComponent txtComponent) {
        this.m_txtComp = txtComponent;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        FormAction fa = new FormAction(this, 3, ResourceBundle.getBundle("org.brains2b.swingext.resource.dialog"));
        this.add((Component)fa, "South");
        this.m_textArea = new JTextPane();
        JScrollPane scroll = new JScrollPane();
        scroll.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new BevelBorder(1)));
        scroll.setViewportView(this.m_textArea);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setPreferredSize(this.getOneFifth());
        this.add((Component)scroll, "Center");
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(fa.getButton(1));
        }
        this.m_textArea.setText(this.m_txtComp.getText());
    }

    public void performApply() {
    }

    public void performOk() {
        if (this.m_txtComp != null) {
            int length;
            if (this.maxLength > 0 && (length = this.m_textArea.getText().length()) > this.maxLength) {
                ResourceBundle b = ResourceBundle.getBundle("org.brains2b.resource.messages", Locale.getDefault());
                JOptionPane.showMessageDialog(this, b.getString("EditorPane.length"));
                this.m_textArea.select(this.maxLength, length);
                this.m_textArea.requestFocus();
                return;
            }
            String text = this.m_textArea.getText();
            if (this.m_txtComp instanceof JTextField) {
                text = text.replace('\n', ' ');
            }
            this.m_txtComp.setText(text);
        }
        this.close();
    }

    public void performUndo() {
    }

    public void performCancel() {
        this.close();
    }

    private Dimension getOneFifth() {
        Dimension d = this.getToolkit().getScreenSize();
        d.height /= 5;
        d.width /= 3;
        return d;
    }

    public static JTextComponent showDialog(Component parent, JTextComponent cmp, String title) {
        Object large = cmp.getClientProperty("large");
        EditorPane edit = new EditorPane(cmp);
        if (large != null) {
            if (large instanceof String && Character.isDigit(((String)large).charAt(0))) {
                edit.setMaxLength(Integer.parseInt((String)large));
            } else if (large instanceof Integer) {
                edit.setMaxLength((Integer)large);
            }
        }
        DialogHelper.showDialog(parent, edit, title);
        return edit.m_txtComp;
    }

    public static JTextComponent showInternalDialog(Component parent, JTextComponent cmp, String title) {
        Object large = cmp.getClientProperty("large");
        EditorPane edit = new EditorPane(cmp);
        if (large != null) {
            if (large instanceof String && Character.isDigit(((String)large).charAt(0))) {
                edit.setMaxLength(Integer.parseInt((String)large));
            } else if (large instanceof Integer) {
                edit.setMaxLength((Integer)large);
            }
        }
        DialogHelper.showInternalDialog(parent, edit, title, null);
        return edit.m_txtComp;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int i) {
        this.maxLength = i;
    }

    private void close() {
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).doDefaultCloseAction();
        } else {
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }
}

