/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.brains2b.util.GuiHelper;

public class DialogHelper {
    public static final void showDialog(Component parent, Container pane, String title) {
        Window window = DialogHelper.getWindowPane(parent);
        JDialog dialog = null;
        dialog = window instanceof Frame || window == null ? new JDialog((Frame)window, true) : new JDialog((Dialog)window, true);
        dialog.setContentPane(pane);
        dialog.setTitle(title);
        dialog.pack();
        dialog.setBounds(GuiHelper.setMiddle(dialog.getBounds(), window.getBounds()));
        dialog.setResizable(false);
        dialog.setVisible(true);
    }

    public static final void showInternalDialog(Component parent, Container pane, String title, Icon icon) {
        JDesktopPane desktop = DialogHelper.getDesktopPane(parent);
        if (desktop == null) {
            throw new RuntimeException("parent has no valid JDesktopPane");
        }
        final JInternalFrame frame = new JInternalFrame();
        desktop.add((Component)frame, JLayeredPane.MODAL_LAYER);
        frame.setContentPane(pane);
        frame.setTitle(title);
        if (icon != null) {
            frame.setFrameIcon(icon);
        }
        frame.pack();
        frame.setBounds(GuiHelper.setMiddle(frame.getBounds(), desktop.getBounds()));
        try {
            frame.setVisible(true);
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                while (!frame.isVisible()) {
                    try {
                        this.wait(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.notify();
                }
            }
        });
    }

    public static final JDesktopPane getDesktopPane(Component parent) {
        if (parent instanceof Window) {
            throw new IllegalArgumentException("You cannot supply an ancestor of the JDesktop pane as parent");
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof JDesktopPane) {
            return (JDesktopPane)parent;
        }
        return DialogHelper.getDesktopPane(parent.getParent());
    }

    public static final Window getWindowPane(Component parent) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return DialogHelper.getWindowPane(parent.getParent());
    }
}

