/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;

public class CalendarPane
extends JPanel
implements Form {
    private MouseHandler mouseH;
    private JPanel month;
    private JButton backYear;
    private JButton backMonth;
    private JButton forwardYear;
    private JButton forwardMonth;
    private JLabel displayCurrent;
    private JLabel lastSelected;
    private Calendar current;

    public CalendarPane(Calendar c) {
        this.current = c;
        this.current.set(11, 0);
        this.current.set(12, 0);
        this.current.set(13, 0);
        this.init();
    }

    private void init() {
        this.mouseH = new MouseHandler();
        this.setLayout(new BorderLayout());
        FormAction fa = new FormAction(this, 3, ResourceBundle.getBundle("org.brains2b.swingext.resource.dialog"));
        if (this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(fa.getButton(1));
        }
        this.add((Component)fa, "South");
        if (this.current == null) {
            this.current = Calendar.getInstance();
        }
        this.displayActions();
        this.makeMonth(this.current);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (pressed) {
            if (e.getKeyCode() == 10) {
                this.performOk();
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 37) {
                this.selectOtherDay(-1);
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 39) {
                this.selectOtherDay(1);
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 38) {
                this.selectOtherDay(-8);
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 40) {
                this.selectOtherDay(8);
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 34) {
                if (e.getModifiers() == 8) {
                    this.current.set(1, this.current.get(1) - 1);
                    this.backYear.doClick();
                    this.makeMonth(this.current);
                    this.validate();
                } else {
                    this.current.set(2, this.current.get(2) - 1);
                    this.backMonth.doClick();
                    this.makeMonth(this.current);
                    this.validate();
                }
                e.consume();
                return true;
            }
            if (e.getKeyCode() == 33) {
                if (e.getModifiers() == 8) {
                    this.current.set(1, this.current.get(1) + 1);
                    this.forwardYear.doClick();
                    this.makeMonth(this.current);
                    this.validate();
                } else {
                    this.current.set(2, this.current.get(2) + 1);
                    this.forwardMonth.doClick();
                    this.makeMonth(this.current);
                    this.validate();
                }
                e.consume();
                return true;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void performApply() {
    }

    public void performOk() {
        this.close();
    }

    public void performUndo() {
    }

    public void performCancel() {
        this.current = null;
        this.close();
    }

    public static Date showDialog(Component parent, Date date, String title) {
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTime(date);
        }
        CalendarPane edit = new CalendarPane(c);
        DialogHelper.showDialog(parent, edit, title);
        if (edit.current != null) {
            return edit.current.getTime();
        }
        return null;
    }

    public static Date showInternalDialog(Component parent, Date date, String title) {
        Calendar c = Calendar.getInstance();
        if (date != null) {
            c.setTime(date);
        }
        CalendarPane edit = new CalendarPane(c);
        DialogHelper.showInternalDialog(parent, edit, title, null);
        if (edit.current != null) {
            return edit.current.getTime();
        }
        return null;
    }

    private void displayActions() {
        JPanel p = new JPanel();
        this.backYear = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("org/brains2b/images/Rewind24.gif")));
        this.backYear.addMouseListener(this.mouseH);
        this.backYear.setBorder(BorderFactory.createEtchedBorder());
        this.backMonth = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("org/brains2b/images/Back24.gif")));
        this.backMonth.addMouseListener(this.mouseH);
        this.backMonth.setBorder(BorderFactory.createEtchedBorder());
        this.displayCurrent = new JLabel("");
        this.displayCurrent.setPreferredSize(new Dimension(140, 27));
        this.displayCurrent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 3, 4)));
        this.displayCurrent.setHorizontalAlignment(0);
        this.forwardYear = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("org/brains2b/images/FastForward24.gif")));
        this.forwardYear.addMouseListener(this.mouseH);
        this.forwardYear.setBorder(BorderFactory.createEtchedBorder());
        this.forwardMonth = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("org/brains2b/images/Play24.gif")));
        this.forwardMonth.addMouseListener(this.mouseH);
        this.forwardMonth.setBorder(BorderFactory.createEtchedBorder());
        p.add(this.backYear);
        p.add(this.backMonth);
        p.add(this.displayCurrent);
        p.add(this.forwardMonth);
        p.add(this.forwardYear);
        this.add((Component)p, "North");
    }

    private void makeMonth(Calendar c) {
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.getDefault());
        String monthTxt = dfs.getMonths()[c.get(2)];
        this.displayCurrent.setText(monthTxt + " " + c.get(1));
        if (this.month != null) {
            this.remove(this.month);
        }
        this.month = new JPanel();
        this.month.setLayout(new GridLayout(7, 8));
        this.month.add((Component)new JLabel(""), 0);
        int[] weekDays = new int[7];
        int first = this.current.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            if (i + first > 7) {
                first = -i + 1;
            }
            weekDays[i] = i + first;
            this.month.add((Component)new JLabel(dfs.getShortWeekdays()[i + first]), i + 1);
        }
        int cnt = 1;
        Calendar week = (Calendar)c.clone();
        Calendar day = (Calendar)c.clone();
        for (int i = 0; i < 48; ++i) {
            if (i % 8 == 0) {
                week.set(5, cnt);
                String weekText = null;
                if (cnt < week.getMaximum(5)) {
                    weekText = String.valueOf(week.get(3));
                }
                JLabel weekLabel = new JLabel(weekText);
                weekLabel.setHorizontalAlignment(0);
                this.month.add(weekLabel);
                continue;
            }
            day.set(5, cnt);
            if (weekDays[i % 8 - 1] == day.get(7) && cnt <= c.getActualMaximum(5)) {
                this.month.add(this.newDay(cnt++));
                continue;
            }
            this.month.add(new JLabel(""));
        }
        this.add((Component)this.month, "Center");
    }

    private JLabel newDay(int i) {
        JLabel day = new JLabel(String.valueOf(i));
        day.setBorder(BorderFactory.createEtchedBorder());
        day.setHorizontalAlignment(0);
        day.setVerticalAlignment(0);
        day.addMouseListener(this.mouseH);
        if (i == this.current.get(5)) {
            this.selectDay(day);
        }
        return day;
    }

    private void selectDay(JLabel day) {
        int idx = Integer.parseInt(day.getText());
        this.current.set(5, idx);
        if (this.lastSelected != null) {
            this.lastSelected.setBorder(BorderFactory.createEtchedBorder());
        }
        day.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2), BorderFactory.createEtchedBorder()));
        this.lastSelected = day;
    }

    private void selectOtherDay(int direction) {
        if (this.lastSelected != null) {
            int index = -1;
            Component[] cmps = this.month.getComponents();
            for (int i = 0; i < cmps.length; ++i) {
                if (cmps[i] != this.lastSelected) continue;
                index = i;
                break;
            }
            if ((index += direction) >= 8 && index < cmps.length) {
                JLabel day;
                if (index % 8 == 0) {
                    index += direction;
                }
                if ((day = (JLabel)this.month.getComponent(index)).getText().length() != 0) {
                    if (this.lastSelected != null) {
                        this.lastSelected.setBorder(BorderFactory.createEtchedBorder());
                    }
                    this.current.set(5, Integer.parseInt(day.getText()));
                    day.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 2), BorderFactory.createEtchedBorder()));
                    this.lastSelected = day;
                }
            }
        }
    }

    private void close() {
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).doDefaultCloseAction();
        } else {
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getSource() instanceof JLabel) {
                CalendarPane.this.selectDay((JLabel)e.getSource());
            } else {
                if (e.getSource() == CalendarPane.this.backYear) {
                    CalendarPane.this.current.set(1, CalendarPane.this.current.get(1) - 1);
                } else if (e.getSource() == CalendarPane.this.backMonth) {
                    CalendarPane.this.current.set(2, CalendarPane.this.current.get(2) - 1);
                } else if (e.getSource() == CalendarPane.this.forwardYear) {
                    CalendarPane.this.current.set(1, CalendarPane.this.current.get(1) + 1);
                } else if (e.getSource() == CalendarPane.this.forwardMonth) {
                    CalendarPane.this.current.set(2, CalendarPane.this.current.get(2) + 1);
                }
                CalendarPane.this.makeMonth(CalendarPane.this.current);
                CalendarPane.this.validate();
            }
        }
    }
}

