/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.gui.IconFactory;
import org.brains2b.util.StringHelper;

public class AboutPane
extends JPanel {
    private GridBagConstraints m_gbc;
    private JLabel m_title = new JLabel();
    private JLabel m_version = new JLabel();
    private JLabel m_date = new JLabel();
    private JLabel m_author = new JLabel();
    private JTextPane m_text = new JTextPane();
    private JLabel m_logo = new JLabel();
    private List m_licLogo = new ArrayList();
    private List m_licText = new ArrayList();
    private JButton m_ok;
    private boolean notInit = true;

    public AboutPane() {
    }

    public AboutPane(Properties prop) {
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setLayout(new GridBagLayout());
        this.m_ok = new JButton("Ok");
        this.m_ok.addActionListener(new ActionEventHandler());
        this.m_ok.setMnemonic('o');
        this.m_gbc = new GridBagConstraints();
        this.m_gbc.insets = new Insets(2, 5, 2, 5);
        this.m_gbc.anchor = 17;
        this.m_text.setEditable(false);
        this.m_text.setForeground(Color.black);
        this.m_text.setBackground(this.getBackground());
        this.m_text.setVisible(true);
        this.layoutItem(this.m_logo, 0, 0, 1, 4);
        this.layoutItem(this.m_title, 1, 0, 2, 1);
        this.layoutItem(this.getLabel("version "), 1, 1, 1, 1);
        this.layoutItem(this.m_version, 2, 1, 1, 1);
        this.layoutItem(this.getLabel("date "), 1, 2, 1, 1);
        this.layoutItem(this.m_date, 2, 2, 1, 1);
        this.layoutItem(this.getLabel("author "), 1, 3, 1, 1);
        this.layoutItem(this.m_author, 2, 3, 1, 1);
        this.layoutItem(new JPanel(), 0, 4, 4, 1);
        if (!StringHelper.isEmpty(this.m_text.getText())) {
            JScrollPane scroll = new JScrollPane(this.m_text);
            scroll.setMinimumSize(new Dimension(400, 100));
            scroll.setPreferredSize(new Dimension(400, 100));
            this.layoutItem(scroll, 1, 5, 3, 1);
            this.m_text.setCaretPosition(0);
        }
        this.layoutItem(new JPanel(), 0, 6, 4, 1);
        int contr = this.m_licText.size();
        for (int i = 0; i < contr; ++i) {
            this.layoutItem((JComponent)this.m_licLogo.get(i), 0, 7 + i, 1, 1);
            this.layoutItem((JComponent)this.m_licText.get(i), 1, 7 + i, 3, 1);
        }
        this.m_gbc.gridx = 3;
        this.m_gbc.gridy = 7 + contr;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.gridheight = 1;
        this.m_gbc.anchor = 13;
        this.m_gbc.insets = new Insets(2, 5, 2, 8);
        this.add((Component)this.m_ok, this.m_gbc);
        this.notInit = false;
    }

    private void layoutItem(JComponent cmp, int x, int y, int w, int h) {
        this.m_gbc.gridx = x;
        this.m_gbc.gridy = y;
        this.m_gbc.gridwidth = w;
        this.m_gbc.gridheight = h;
        this.add((Component)cmp, this.m_gbc);
    }

    public Dimension getPreferredSize() {
        if (this.notInit) {
            this.init();
        }
        return super.getPreferredSize();
    }

    private void close() {
        if (this.getRootPane().getParent() instanceof JInternalFrame) {
            ((JInternalFrame)this.getRootPane().getParent()).doDefaultCloseAction();
        } else {
            SwingUtilities.getWindowAncestor(this).dispose();
        }
    }

    private JLabel getLabel(String text) {
        JLabel lbl = new JLabel(text);
        lbl.setForeground(Color.black);
        lbl.setBackground(this.getBackground());
        return lbl;
    }

    public void setLogo(String fileName) {
        this.setLogo(fileName, true);
    }

    public void setLogo(String fileName, boolean border) {
        this.m_logo = this.getLabel(null);
        if (border) {
            this.m_logo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        this.m_logo.setIcon(IconFactory.createIcon(fileName, 64));
    }

    public void setTitle(String title) {
        this.m_title = this.getLabel(title);
        this.m_title.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        Font f = this.m_title.getFont().deriveFont(1, 30.0f);
        this.m_title.setFont(f);
    }

    public void setVersion(String version) {
        this.m_version = this.getLabel(version);
    }

    public void setDate(String date) {
        this.m_date = this.getLabel(date);
    }

    public void setAuthor(String author) {
        this.m_author = this.getLabel(author);
    }

    public void setText(String text) {
        this.m_text.setText(text);
    }

    private String getTextfromFile(String fileName) throws IOException {
        try {
            File f;
            InputStream resource = this.getClass().getResourceAsStream(fileName);
            if (resource == null && (f = new File(fileName)).exists()) {
                resource = new FileInputStream(f);
            }
            BufferedReader bfr = new BufferedReader(new InputStreamReader(resource));
            StringBuffer sb = new StringBuffer();
            String str = bfr.readLine();
            while (str != null) {
                sb.append(str);
                sb.append('\n');
                str = bfr.readLine();
            }
            bfr.close();
            return sb.toString();
        }
        catch (NullPointerException npex) {
            throw new FileNotFoundException("File " + fileName + " cannot be found.");
        }
    }

    public void setTextfromFile(String fileName) throws IOException {
        this.setText(this.getTextfromFile(fileName));
    }

    public void addContributor(String logoFile, String text) {
        JLabel logo = this.getLabel(null);
        if (logoFile != null) {
            logo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            logo.setIcon(IconFactory.createIcon(logoFile, 64));
        }
        this.m_licLogo.add(logo);
        JTextPane licentie = new JTextPane();
        licentie.setForeground(Color.black);
        licentie.setBackground(this.getBackground());
        licentie.setEditable(false);
        licentie.setText(text);
        licentie.setAutoscrolls(true);
        licentie.setSelectionStart(0);
        licentie.setSelectionEnd(0);
        JScrollPane pane = new JScrollPane(licentie);
        pane.setMinimumSize(new Dimension(400, 100));
        pane.setPreferredSize(new Dimension(400, 100));
        this.m_licText.add(pane);
    }

    public void addContributorFile(String logoFile, String textFile) throws IOException {
        this.addContributor(logoFile, this.getTextfromFile(textFile));
    }

    public static void showDialog(Component parent) {
        AboutPane pane = new AboutPane();
        DialogHelper.showDialog(parent, pane, "Connections");
    }

    public static void showInternalDialog(Component parent, String title, Icon icon) {
        AboutPane pane = new AboutPane();
        DialogHelper.showInternalDialog(parent, pane, title, icon);
    }

    private class ActionEventHandler
    implements ActionListener {
        private ActionEventHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AboutPane.this.m_ok) {
                AboutPane.this.close();
            }
        }
    }
}

