/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.connect;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.brains2b.jdbc.Driver;
import org.brains2b.loader.DynamicClassLoader;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;
import org.brains2b.swingext.gui.IconFactory;

public class DriverView
extends JPanel
implements Form {
    private static final String TITLE = "Driver information";
    private JComboBox driverName;
    private JTextField urlPrefix;
    private JLabel message;
    private JList classPath;
    private List m_drivers;
    private Driver m_driver;

    public DriverView() {
        this.init();
    }

    public static Driver showDailog(Window parent, List drivers, Driver d) {
        JDialog dlg = null;
        dlg = parent instanceof JDialog ? new JDialog((Dialog)((JDialog)parent), true) : new JDialog((Frame)((JFrame)parent), true);
        dlg.setTitle(TITLE);
        dlg.setLocationRelativeTo(parent);
        DriverView view = new DriverView();
        view.setDriver(d);
        view.setDrivers(drivers);
        dlg.setContentPane(view);
        dlg.pack();
        dlg.setVisible(true);
        return view.getDriver();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel main = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ActionHandler ah = new ActionHandler();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridx = 0;
        main.add((Component)new JLabel("driver className"), gbc);
        this.driverName = new JComboBox();
        this.driverName.setEditable(true);
        gbc.fill = 2;
        ++gbc.gridx;
        main.add((Component)this.driverName, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        main.add((Component)new JLabel("url prefix"), gbc);
        ++gbc.gridx;
        this.urlPrefix = new JTextField();
        this.urlPrefix.setColumns(20);
        main.add((Component)this.urlPrefix, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        main.add((Component)new JLabel("classpath"), gbc);
        ++gbc.gridx;
        gbc.gridheight = 5;
        gbc.fill = 1;
        this.classPath = new JList();
        this.classPath.setFixedCellWidth(256);
        this.classPath.setModel(new DefaultListModel());
        main.add((Component)new JScrollPane(this.classPath), gbc);
        gbc.gridheight = 1;
        ++gbc.gridx;
        gbc.insets = new Insets(0, 5, 0, 5);
        JButton btnAdd = new JButton(IconFactory.createIcon("/org/brains2b/images/Open16.gif"));
        btnAdd.setActionCommand("classpath.Open");
        btnAdd.addActionListener(ah);
        main.add((Component)btnAdd, gbc);
        ++gbc.gridy;
        JButton btnRem = new JButton(IconFactory.createIcon("/org/brains2b/images/Minus16.gif"));
        btnRem.addActionListener(ah);
        btnRem.setActionCommand("classpath.Remove");
        main.add((Component)btnRem, gbc);
        ++gbc.gridy;
        JButton btnScan = new JButton(IconFactory.createIcon("/org/brains2b/images/Find16.png"));
        btnScan.addActionListener(ah);
        btnScan.setActionCommand("classpath.Scan");
        main.add((Component)btnScan, gbc);
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridy += 5;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.message = new JLabel(" ");
        this.message.setForeground(Color.red);
        main.add((Component)this.message, gbc);
        this.add((Component)main, "Center");
        FormAction fa = new FormAction(this, 11);
        fa.getButton(8).setText("Delete");
        this.add((Component)fa, "South");
    }

    public void performApply() {
    }

    public void performOk() {
        URL[] path;
        String name = this.driverName.getSelectedItem().toString();
        if (name.trim().length() == 0) {
            name = null;
        }
        if (name != null) {
            int size = ((DefaultListModel)this.classPath.getModel()).size();
            path = null;
            if (size > 0) {
                path = new URL[size];
                for (int i = 0; i < size; ++i) {
                    try {
                        path[i] = ((File)((DefaultListModel)this.classPath.getModel()).getElementAt(i)).toURL();
                        continue;
                    }
                    catch (MalformedURLException muex) {
                        this.message.setText("Not a valid classpath");
                    }
                }
            }
            try {
                DynamicClassLoader.loadClass(name, path);
            }
            catch (ClassNotFoundException cnfex) {
                this.message.setText("Driver not found in classpath, cannot add driver");
                return;
            }
            if (this.m_driver == null && this.m_drivers != null) {
                for (Driver d : this.m_drivers) {
                    if (!name.equals(d.getClassName())) continue;
                    this.message.setText("Driver is already defined");
                    return;
                }
            }
            if (this.m_driver == null) {
                this.m_driver = new Driver(name, this.urlPrefix.getText());
            } else {
                this.m_driver.setClassName(name);
                this.m_driver.setUrlprefix(this.urlPrefix.getText());
            }
        } else {
            this.message.setText("Enter a driver name, or press cancel");
            return;
        }
        this.m_driver.setClassPath(path);
        this.close();
    }

    public void performUndo() {
        this.m_driver.setClassName("DELETED");
        this.close();
    }

    public void performCancel() {
        this.m_driver = null;
        this.close();
    }

    public Driver getDriver() {
        return this.m_driver;
    }

    public void setDriver(Driver driver) {
        this.m_driver = driver;
        if (driver != null) {
            this.driverName.setSelectedItem(driver.getClassName());
            this.urlPrefix.setText(driver.getUrlprefix());
            if (driver.getClassPath() != null) {
                for (int i = 0; i < driver.getClassPath().length; ++i) {
                    ((DefaultListModel)this.classPath.getModel()).addElement(new File(driver.getClassPath()[i].getPath()));
                }
            }
        }
    }

    public void setDrivers(List drivers) {
        this.m_drivers = drivers;
    }

    private void close() {
        Window w = SwingUtilities.windowForComponent(this);
        if (w instanceof JDialog) {
            ((JDialog)w).setVisible(false);
            ((JDialog)w).dispose();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent arg0) {
            if ("classpath.Open".equals(arg0.getActionCommand())) {
                File f = null;
                if (DriverView.this.m_driver != null && DriverView.this.m_driver.getClassPath() != null) {
                    f = new File(DriverView.this.m_driver.getClassPath()[0].getFile());
                }
                JFileChooser jfc = new JFileChooser(f);
                jfc.setMultiSelectionEnabled(true);
                jfc.showOpenDialog(DriverView.this);
                File[] file = jfc.getSelectedFiles();
                for (int i = 0; i < file.length; ++i) {
                    ((DefaultListModel)DriverView.this.classPath.getModel()).addElement(file[i]);
                }
            } else if ("classpath.Remove".equals(arg0.getActionCommand())) {
                int[] idx = DriverView.this.classPath.getSelectedIndices();
                for (int i = 0; i < idx.length; ++i) {
                    ((DefaultListModel)DriverView.this.classPath.getModel()).removeElementAt(idx[i]);
                }
            } else if ("classpath.Scan".equals(arg0.getActionCommand())) {
                int size = ((DefaultListModel)DriverView.this.classPath.getModel()).size();
                URL[] path = null;
                if (size > 0) {
                    path = new URL[size];
                    for (int i = 0; i < size; ++i) {
                        try {
                            path[i] = ((File)((DefaultListModel)DriverView.this.classPath.getModel()).getElementAt(i)).toURL();
                            continue;
                        }
                        catch (MalformedURLException muex) {
                            DriverView.this.message.setText("Not a valid classpath");
                            return;
                        }
                    }
                    try {
                        Class[] c = DynamicClassLoader.findImplementation(java.sql.Driver.class, path);
                        if (c.length == 0) {
                            DriverView.this.message.setText("classpath contains no drivers");
                            return;
                        }
                        for (int i = 0; i < c.length; ++i) {
                            DriverView.this.driverName.addItem(c[i].getName());
                        }
                        DriverView.this.driverName.setSelectedIndex(0);
                    }
                    catch (ClassNotFoundException cnfex) {
                        DriverView.this.message.setText("Error trying to find driver");
                    }
                } else {
                    DriverView.this.message.setText("Please provide a classpath first.");
                }
            }
        }
    }
}

