/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.swingext.connect;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.brains2b.jdbc.Connection;
import org.brains2b.jdbc.ConnectionDocument;
import org.brains2b.jdbc.Driver;
import org.brains2b.saxo.SAXReader;
import org.brains2b.sql.LocalConnector;
import org.brains2b.swingext.connect.DriverView;
import org.brains2b.swingext.form.Form;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ConnectionView
extends JPanel {
    private static ConnectionDocument document;
    private JTextField message;
    private JComboBox drivers;
    private JTextField url;
    private JTextField user;
    private JTextField password;
    private JTable table;
    private JButton btnDelete;
    private JButton btnTest;
    private File m_connectFile;

    public ConnectionView() {
        this.init();
        this.initConnections();
    }

    public boolean close() {
        boolean result = true;
        if (document.getConnections() != null) {
            for (int i = 0; i < document.getConnections().size() && (result = this.isConnectionValid((Connection)document.getConnections().get(i), true)); ++i) {
            }
        }
        if (result) {
            this.writeConnections();
        }
        return result;
    }

    public void setSelectedConnection(Properties p) {
        this.setSelectedConnection(p, null);
    }

    public void setSelectedConnection(Properties p, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Connection c = new Connection(p.getProperty(prefix + "user") + "@" + p.getProperty(prefix + "url"), p.getProperty(prefix + "driver"), p.getProperty(prefix + "url"), p.getProperty(prefix + "user"), p.getProperty(prefix + "password"));
        int idx = -1;
        for (int i = 0; i < document.getConnections().size(); ++i) {
            Connection co = (Connection)document.getConnections().get(i);
            if (!co.getUrl().equals(c.getUrl()) || co.getUser() != null && !co.getUser().equals(c.getUser())) continue;
            idx = i;
        }
        if (idx == -1) {
            document.addConnection(c);
        }
        this.table.getSelectionModel().setSelectionInterval(idx, idx);
    }

    public Properties getSelectedConnection() {
        return this.getSelectedConnection(null);
    }

    public Properties getSelectedConnection(String prefix) {
        int idx;
        if (prefix == null) {
            prefix = "";
        }
        if ((idx = this.table.getSelectedRow()) != -1) {
            Connection c = (Connection)document.getConnections().get(idx);
            Properties p = new Properties();
            p.setProperty(prefix + "driver", c.getDriver());
            p.setProperty(prefix + "url", c.getUrl());
            p.setProperty(prefix + "user", c.getUser());
            p.setProperty(prefix + "password", c.getPassword());
            String path = this.findClassPath(c.getDriver());
            if (path != null) {
                p.setProperty(prefix + "classpath", path);
            }
            return p;
        }
        return null;
    }

    public void setConnectFile(File f) {
        this.m_connectFile = f;
        document = null;
        this.initConnections();
    }

    protected File getConnectFile() {
        if (this.m_connectFile == null) {
            this.m_connectFile = new File("conf", "connections.xml");
        }
        return this.m_connectFile;
    }

    private void init() {
        ActionHandler ah = new ActionHandler();
        FocusHandler fh = new FocusHandler();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel list = new JPanel(new BorderLayout());
        this.table = new JTable();
        this.table.getSelectionModel().addListSelectionListener(new SelectionHander());
        this.table.addMouseListener(new MouseHandler());
        JScrollPane scrollTable = new JScrollPane();
        scrollTable.setPreferredSize(new Dimension(400, 150));
        scrollTable.setViewportView(this.table);
        this.table.setModel(new ConnectionTableModel());
        this.setColumnModel(this.table);
        list.add((Component)scrollTable, "Center");
        JPanel buttons = new JPanel(new FlowLayout(2));
        JButton btnNew = new JButton("new");
        btnNew.setActionCommand("new");
        btnNew.addActionListener(ah);
        buttons.add(btnNew);
        this.btnDelete = new JButton("remove");
        this.btnDelete.setActionCommand("remove");
        this.btnDelete.addActionListener(ah);
        this.btnDelete.setEnabled(false);
        buttons.add(this.btnDelete);
        list.add((Component)buttons, "South");
        this.add((Component)list, "Center");
        JPanel detail = new JPanel(new GridBagLayout());
        detail.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 21;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        detail.add((Component)new JLabel("driver:"), gbc);
        this.drivers = new JComboBox();
        this.drivers.setName("driverName");
        this.drivers.addFocusListener(fh);
        gbc.fill = 1;
        ++gbc.gridx;
        gbc.gridwidth = 2;
        detail.add((Component)this.drivers, gbc);
        JButton btnDriver = new JButton("edit");
        btnDriver.setActionCommand("driver.Edit");
        btnDriver.addActionListener(ah);
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridx += 2;
        detail.add((Component)btnDriver, gbc);
        JButton btnAddDriver = new JButton("add");
        btnAddDriver.setActionCommand("driver.Add");
        btnAddDriver.addActionListener(ah);
        gbc.gridwidth = 1;
        ++gbc.gridx;
        detail.add((Component)btnAddDriver, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        detail.add((Component)new JLabel("url:"), gbc);
        this.url = new JTextField();
        this.url.setName("url");
        this.url.addFocusListener(fh);
        gbc.fill = 1;
        ++gbc.gridx;
        gbc.gridwidth = 4;
        detail.add((Component)this.url, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        detail.add((Component)new JLabel("user:"), gbc);
        this.user = new JTextField();
        this.user.setName("user");
        this.user.addFocusListener(fh);
        ++gbc.gridx;
        gbc.weightx = 0.4;
        detail.add((Component)this.user, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        detail.add((Component)new JLabel("password:"), gbc);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.weightx = 0.4;
        this.password = new JPasswordField();
        this.password.setName("password");
        this.password.addFocusListener(fh);
        detail.add((Component)this.password, gbc);
        this.message = new JTextField(" ");
        this.message.setOpaque(false);
        this.message.setEditable(false);
        this.message.setFocusable(false);
        this.message.setBorder(BorderFactory.createEmptyBorder());
        this.message.setForeground(Color.red);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        detail.add((Component)this.message, gbc);
        this.btnTest = new JButton("test");
        this.btnTest.setActionCommand("test");
        this.btnTest.addActionListener(ah);
        this.btnTest.setEnabled(false);
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.gridx += 3;
        detail.add((Component)this.btnTest, gbc);
        this.add((Component)detail, "South");
    }

    private void setColumnModel(JTable table) {
        int idx = 0;
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        TableColumn t = new TableColumn(idx++, 100);
        t.setIdentifier("driverName");
        t.setHeaderValue("driver");
        model.addColumn(t);
        t = new TableColumn(idx++, 125);
        t.setIdentifier("url");
        t.setHeaderValue("url");
        model.addColumn(t);
        t = new TableColumn(idx++, 50);
        t.setIdentifier("user");
        t.setHeaderValue("user");
        model.addColumn(t);
        table.setColumnModel(model);
    }

    private void initConnections() {
        if (document == null) {
            try {
                document = new ConnectionDocument();
                SAXReader p = new SAXReader();
                p.setContentHandler((ContentHandler)document);
                p.parse(this.getConnectFile().getAbsolutePath());
                this.fillDrivers();
            }
            catch (SAXException saex) {
            }
            catch (FileNotFoundException fnex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeConnections() {
        document.setAction(1);
        document.setFilename(this.getConnectFile().getAbsolutePath());
        Thread t = new Thread(document);
        t.start();
    }

    private void fillDrivers() {
        if (document.getDrivers() != null) {
            Iterator it = document.getDrivers().iterator();
            while (it.hasNext()) {
                this.drivers.addItem(it.next());
            }
        }
    }

    private void setMessage(String text, Color c) {
        this.message.setText(text);
        this.message.setForeground(c);
        this.message.setCaretPosition(0);
    }

    private boolean isConnectionValid(Connection c, boolean showMessage) {
        boolean result = true;
        int idx = document.getConnections().indexOf(c);
        if (ConnectionView.isEmpty(c.getDriver())) {
            if (showMessage) {
                this.setMessage("Did not define a driver for this connection", Color.red);
            }
            result = false;
        } else if (ConnectionView.isEmpty(c.getUrl())) {
            if (showMessage) {
                this.setMessage("Did not define a URL for this connection", Color.red);
            }
            result = false;
        }
        if (!result) {
            this.table.clearSelection();
            this.table.addRowSelectionInterval(idx, idx);
        }
        return result;
    }

    private static final boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void fireDriver(Driver driver) {
        Driver d = DriverView.showDailog(SwingUtilities.windowForComponent(this), document.getDrivers(), driver);
        if (d != null) {
            if ("DELETED".equals(d.getClassName())) {
                document.removeDriver(d);
                this.drivers.removeItem(d);
                this.drivers.requestFocus();
            } else {
                if (document.getDrivers() != null) {
                    document.getDrivers().remove(d);
                }
                document.addDriver(d);
                this.drivers.addItem(d);
                this.drivers.setSelectedItem(d);
                this.drivers.requestFocus();
            }
        }
    }

    private Connection getCurrentConnection() {
        int row = this.table.getSelectedRow();
        Connection c = null;
        if (row == -1) {
            c = new Connection();
            document.addConnection(c);
            int newRow = document.getConnections().size() - 1;
            ((DefaultTableModel)this.table.getModel()).fireTableRowsInserted(newRow, newRow);
            this.table.addRowSelectionInterval(newRow, newRow);
        } else {
            c = (Connection)document.getConnections().get(row);
        }
        return c;
    }

    private String findClassPath(String driverName) {
        if (driverName == null) {
            return null;
        }
        List drivers = document.getDrivers();
        if (drivers != null) {
            for (int i = 0; i < drivers.size(); ++i) {
                URL[] cs;
                if (!driverName.equals(((Driver)drivers.get(i)).getClassName()) || (cs = ((Driver)drivers.get(i)).getClassPath()) == null || cs.length <= 0) continue;
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < cs.length; ++j) {
                    sb.append(cs[j].getPath());
                }
                return sb.toString();
            }
        }
        return null;
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            Container c;
            if (e.getClickCount() >= 2 && (c = ConnectionView.this.getParent()) instanceof Form) {
                ((Form)((Object)c)).performOk();
            }
        }
    }

    private class ConnectionTableModel
    extends DefaultTableModel {
        public Class getColumnClass(int arg0) {
            return String.class;
        }

        public int getRowCount() {
            if (document != null && document.getConnections() != null) {
                return document.getConnections().size();
            }
            return 0;
        }

        public Object getValueAt(int arg0, int arg1) {
            if (document == null || document.getConnections() == null) {
                return null;
            }
            Connection c = (Connection)document.getConnections().get(arg0);
            switch (arg1) {
                case 0: {
                    return c.getDriver();
                }
                case 1: {
                    return c.getUrl();
                }
                case 2: {
                    return c.getUser();
                }
            }
            return null;
        }

        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }
    }

    private class SelectionHander
    implements ListSelectionListener {
        private SelectionHander() {
        }

        public void valueChanged(ListSelectionEvent arg0) {
            int row = ConnectionView.this.table.getSelectedRow();
            boolean b = false;
            if (row != -1 && row < ConnectionView.this.table.getRowCount()) {
                Connection c = (Connection)document.getConnections().get(row);
                b = true;
                for (int i = 0; i < ConnectionView.this.drivers.getItemCount(); ++i) {
                    Driver driver = (Driver)ConnectionView.this.drivers.getItemAt(i);
                    if (c.getDriver() == null || !c.getDriver().equals(driver.getClassName())) continue;
                    ConnectionView.this.drivers.setSelectedIndex(i);
                }
                ConnectionView.this.url.setText(c.getUrl());
                ConnectionView.this.user.setText(c.getUser());
                ConnectionView.this.password.setText(c.getPassword());
            }
            ConnectionView.this.btnDelete.setEnabled(b);
            ConnectionView.this.btnTest.setEnabled(b);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent arg0) {
            int idx;
            if (arg0.getActionCommand().equals("driver.Add")) {
                ConnectionView.this.getCurrentConnection();
                ConnectionView.this.fireDriver(null);
            } else if (arg0.getActionCommand().equals("driver.Edit")) {
                ConnectionView.this.getCurrentConnection();
                ConnectionView.this.fireDriver((Driver)ConnectionView.this.drivers.getSelectedItem());
            } else if (arg0.getActionCommand().equals("new")) {
                int idx2 = ConnectionView.this.table.getSelectedRow();
                if (idx2 == -1 || ConnectionView.this.isConnectionValid((Connection)document.getConnections().get(idx2), false)) {
                    ConnectionView.this.table.clearSelection();
                    document.addConnection(new Connection());
                    idx2 = document.getConnections().size() - 1;
                }
                if (ConnectionView.this.drivers.getItemCount() > 0) {
                    ConnectionView.this.drivers.setSelectedIndex(0);
                }
                ConnectionView.this.url.setText("");
                ConnectionView.this.user.setText("");
                ConnectionView.this.password.setText("");
                ((ConnectionTableModel)ConnectionView.this.table.getModel()).fireTableRowsInserted(idx2, idx2);
                ConnectionView.this.table.addRowSelectionInterval(idx2, idx2);
            } else if (arg0.getActionCommand().equals("remove")) {
                int idx3 = ConnectionView.this.table.getSelectedRow();
                if (idx3 != -1) {
                    Connection c = (Connection)document.getConnections().get(idx3);
                    document.removeConnection(c);
                    ((ConnectionTableModel)ConnectionView.this.table.getModel()).fireTableRowsDeleted(idx3, idx3);
                    if (idx3 > 0) {
                        --idx3;
                    }
                    ConnectionView.this.table.getSelectionModel().setSelectionInterval(idx3, idx3);
                }
            } else if (arg0.getActionCommand().equals("test") && (idx = ConnectionView.this.table.getSelectedRow()) != -1) {
                Connection c = (Connection)document.getConnections().get(idx);
                String classpath = ConnectionView.this.findClassPath(c.getDriver());
                LocalConnector con = new LocalConnector(classpath, c.getDriver(), c.getUrl(), c.getUser(), c.getPassword());
                try {
                    con.getConnection();
                    ConnectionView.this.setMessage("Succes!", Color.blue);
                }
                catch (SQLException sqex) {
                    ConnectionView.this.setMessage(sqex.getMessage(), Color.red);
                }
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        public void focusGained(FocusEvent arg0) {
        }

        public void focusLost(FocusEvent arg0) {
            ConnectionView.this.message.setText(" ");
            Connection c = ConnectionView.this.getCurrentConnection();
            int row = ConnectionView.this.table.getSelectedRow();
            String name = arg0.getComponent().getName();
            String value = null;
            if (name.equals("driverName")) {
                Driver d = (Driver)((JComboBox)arg0.getComponent()).getSelectedItem();
                if (d == null) {
                    return;
                }
                value = d.getClassName();
                c.setDriver(value);
                if (ConnectionView.isEmpty(ConnectionView.this.url.getText())) {
                    ConnectionView.this.url.setText(d.getUrlprefix());
                    c.setUrl(d.getUrlprefix());
                }
            } else if (name.equals("password")) {
                value = new String(((JPasswordField)arg0.getComponent()).getPassword());
                c.setPassword(value);
            } else if (arg0.getComponent() instanceof JTextField) {
                value = ((JTextField)arg0.getComponent()).getText();
                if (name.equals("user")) {
                    c.setUser(value);
                } else if (name.equals("url")) {
                    c.setUrl(value);
                }
            }
            ConnectionView.this.btnTest.setEnabled(ConnectionView.this.isConnectionValid(c, false));
            ((ConnectionTableModel)ConnectionView.this.table.getModel()).fireTableRowsUpdated(row, row + 1);
        }
    }
}

