/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.jdbc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.brains2b.jdbc.Connection;
import org.brains2b.jdbc.Driver;
import org.brains2b.saxo.SAXReader;
import org.brains2b.saxo.SAXWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ConnectionDocument
implements ContentHandler,
Runnable {
    public static final int READ = 0;
    public static final int WRITE = 1;
    private int action = 0;
    private String filename;
    private Object last;
    private String lastName;
    private List drivers;
    private List connections;

    public void setDocumentLocator(Locator arg0) {
    }

    public void startDocument() throws SAXException {
        this.drivers = new ArrayList();
        this.connections = new ArrayList();
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals("driver")) {
            this.last = new Driver();
            this.drivers.add(this.last);
        } else if (localName.equals("connection")) {
            this.last = new Connection();
            this.connections.add(this.last);
        } else if (localName.equals("classpath")) {
            this.last = new ArrayList();
        } else {
            this.lastName = localName;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("classpath") && this.last instanceof ArrayList && !this.drivers.isEmpty()) {
            URL[] urls = new URL[((ArrayList)this.last).size()];
            ((ArrayList)this.last).toArray(urls);
            Driver d = (Driver)this.drivers.get(this.drivers.size() - 1);
            d.setClassPath(urls);
            this.last = d;
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.last instanceof Driver) {
            Driver d = (Driver)this.last;
            if (this.lastName.equals("name")) {
                d.setClassName(new String(arg0));
            } else if (this.lastName.equals("url")) {
                d.setUrlprefix(new String(arg0));
            }
        } else if (this.last instanceof Connection) {
            Connection c = (Connection)this.last;
            if (this.lastName.equals("driverName")) {
                c.setDriver(new String(arg0));
            } else if (this.lastName.equals("url")) {
                c.setUrl(new String(arg0));
            } else if (this.lastName.equals("user")) {
                c.setUser(new String(arg0));
            } else if (this.lastName.equals("password")) {
                c.setPassword(new String(arg0));
            }
        } else if (this.last instanceof ArrayList) {
            try {
                ((ArrayList)this.last).add(new URL(new String(arg0)));
            }
            catch (MalformedURLException muex) {
                throw new SAXException(muex);
            }
        }
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    public List getConnections() {
        return this.connections;
    }

    public List getDrivers() {
        return this.drivers;
    }

    public void setConnections(List list) {
        this.connections = list;
    }

    public void setDrivers(List list) {
        this.drivers = list;
    }

    public void writeDocument(String fileName) throws IOException, SAXException {
        Iterator it;
        FileWriter fw = new FileWriter(fileName);
        SAXWriter sw = new SAXWriter((Writer)fw);
        sw.startDocument();
        sw.startElement("connectionInfo", null);
        if (this.drivers != null) {
            it = this.drivers.iterator();
            while (it.hasNext()) {
                this.write(sw, (Driver)it.next());
            }
        }
        if (this.connections != null) {
            it = this.connections.iterator();
            while (it.hasNext()) {
                this.write(sw, (Connection)it.next());
            }
        }
        sw.endElement("connectionInfo");
        fw.close();
    }

    private void write(SAXWriter w, Driver d) throws SAXException {
        w.startElement("driver", null);
        w.startElement("name", null);
        w.setContent(d.getClassName());
        w.endElement("name");
        w.startElement("url", null);
        w.setContent(d.getUrlprefix());
        w.endElement("url");
        if (d.getClassPath() != null) {
            w.startElement("classpath", null);
            for (int i = 0; i < d.getClassPath().length; ++i) {
                w.startElement("path", null);
                w.setContent(d.getClassPath()[i].toString());
                w.endElement("path");
            }
            w.endElement("classpath");
        }
        w.endElement("driver");
    }

    private void write(SAXWriter w, Connection c) throws SAXException {
        w.startElement("connection", null);
        w.startElement("driverName", null);
        w.setContent(c.getDriver());
        w.endElement("driverName");
        w.startElement("url", null);
        w.setContent(c.getUrl());
        w.endElement("url");
        w.startElement("user", null);
        w.setContent(c.getUser());
        w.endElement("user");
        w.startElement("password", null);
        w.setContent(c.getPassword());
        w.endElement("password");
        w.endElement("connection");
    }

    public void run() {
        try {
            if (this.getAction() == 1) {
                this.writeDocument(this.getFilename());
            } else if (this.getAction() == 0) {
                SAXReader reader = new SAXReader();
                reader.setContentHandler(this);
                reader.parse(new InputSource(this.getFilename()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getAction() {
        return this.action;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setAction(int i) {
        this.action = i;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void addDriver(Driver d) {
        if (this.drivers == null) {
            this.drivers = new ArrayList();
        }
        this.drivers.add(d);
    }

    public void removeDriver(Driver d) {
        if (this.drivers == null) {
            return;
        }
        this.drivers.remove(d);
    }

    public void addConnection(Connection c) {
        if (this.connections == null) {
            this.connections = new ArrayList();
        }
        this.connections.add(c);
    }

    public void removeConnection(Connection c) {
        if (this.connections != null) {
            this.connections.remove(c);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

