/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.tasks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.brains2b.task.DefaultTask;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.BinaryElement;
import org.brains2b.thex.PseudoCaretComponent;

public class FindTask
extends DefaultTask {
    private JTextComponent m_text;
    private byte[] m_byte;
    private int m_start;
    private int m_end;
    private Position.Bias m_direction;
    private boolean m_findAll;

    public FindTask(JTextComponent t, byte[] b, int start, int end, Position.Bias direction, boolean findAll) {
        this.m_text = t;
        this.m_byte = b;
        this.m_start = start;
        this.m_end = end;
        this.m_direction = direction != null ? direction : Position.Bias.Forward;
        this.m_findAll = findAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BinaryDocument doc = (BinaryDocument)this.m_text.getDocument();
        int p = this.m_text.getCaret().getDot();
        if (p < this.m_start) {
            p = this.m_start;
        } else if (p > this.m_end) {
            p = this.m_end;
        }
        int foundIdx = p;
        int idx = doc.getDefaultRootElement().getElementIndex(p);
        try {
            Highlighter.Highlight bs;
            while (idx != -1 && idx >= 0 && idx < doc.getDefaultRootElement().getElementCount()) {
                BinaryElement elem = (BinaryElement)doc.getDefaultRootElement().getElement(idx);
                p = elem.getStartOffset() > p ? elem.getStartOffset() : p;
                byte[] b = doc.getBytes(p, elem.getEndOffset() - p);
                for (int i = 0; i < b.length; ++i) {
                    foundIdx = i;
                    for (int j = 0; j < this.m_byte.length; ++j) {
                        if (b[i + j] == this.m_byte[j]) continue;
                        foundIdx = -1;
                        break;
                    }
                    if (foundIdx == -1) continue;
                    foundIdx = p + foundIdx;
                    if (!this.m_findAll) {
                        idx = -1;
                        break;
                    }
                    ((PseudoCaretComponent)((Object)this.m_text)).getFindHighlighter().addHighlight(foundIdx, foundIdx + this.m_byte.length, null);
                }
                if (idx == -1) continue;
                idx += 1 * (Position.Bias.Forward.equals(this.m_direction) ? 1 : -1);
            }
            if (!this.m_findAll && foundIdx != -1) {
                ((PseudoCaretComponent)((Object)this.m_text)).getFindHighlighter().addHighlight(foundIdx, foundIdx + this.m_byte.length, null);
            }
            if ((bs = ((PseudoCaretComponent)((Object)this.m_text)).getFindHighlighter().findHighlight(p, this.m_direction)) != null) {
                this.m_text.getCaret().setDot(bs.getStartOffset());
                this.m_text.getCaret().moveDot(bs.getEndOffset());
            }
        }
        catch (BadLocationException blex) {
            this.setResult(1);
        }
        finally {
            this.setFinished(true);
        }
    }

    public static final int find(BinaryDocument doc, byte[] bb, int start, int end) {
        int p;
        int foundIdx = p = start;
        int idx = doc.getDefaultRootElement().getElementIndex(p);
        try {
            while (idx != -1 && idx >= 0 && idx < doc.getDefaultRootElement().getElementCount()) {
                BinaryElement elem = (BinaryElement)doc.getDefaultRootElement().getElement(idx);
                p = elem.getStartOffset() > p ? elem.getStartOffset() : p;
                byte[] b = doc.getBytes(p, elem.getEndOffset() - p);
                for (int i = 0; i < b.length; ++i) {
                    foundIdx = i;
                    for (int j = 0; j < bb.length; ++j) {
                        if (b[i + j] == bb[j]) continue;
                        foundIdx = -1;
                        break;
                    }
                    if (foundIdx == -1) continue;
                    foundIdx = p + foundIdx;
                    idx = -1;
                    break;
                }
                if (idx == -1) continue;
                ++idx;
            }
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
        return foundIdx;
    }
}

