/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.mark;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;
import org.brains2b.swingext.gui.ExtButtonGroup;
import org.brains2b.swingext.mask.CalculateParser;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.mark.MarkRule;
import org.brains2b.thex.tasks.FindTask;
import org.brains2b.util.StringHelper;

public class MarkPane
extends JPanel
implements Form {
    private ResourceBundle m_resource;
    private BinaryDocument m_document;
    private JTextField m_name;
    private ExtButtonGroup m_typeStart;
    private JTextField m_start;
    private JTextField m_currStart;
    private ExtButtonGroup m_typeEnd;
    private JTextField m_end;
    private JTextField m_currEnd;
    private JEditorPane m_note;
    private ExtButtonGroup m_occurance;
    private JComboBox m_occurStart;
    private JComboBox m_occurType;
    private JTextField m_occurValue;
    private FormAction m_actions;
    private MarkRule m_rule;

    public MarkPane() {
        this.init();
    }

    private void init() {
        this.m_resource = ResourceBundle.getBundle("org.brains2b.thex.resource.mark");
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.Name.Label")), gbc);
        gbc.gridx = 1;
        this.m_name = new JTextField();
        this.m_name.setColumns(12);
        p.add((Component)this.m_name, gbc);
        this.m_currStart = new JTextField();
        CurrentUpdate cstart = new CurrentUpdate(this.m_currStart);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.m_typeStart = this.createTypeGroup(p, gbc, cstart);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.Start.Label")), gbc);
        ++gbc.gridx;
        this.m_start = new JTextField();
        this.m_start.setColumns(16);
        this.m_start.addActionListener(cstart);
        p.add((Component)this.m_start, gbc);
        ++gbc.gridx;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.Current.Label")), gbc);
        ++gbc.gridx;
        this.m_currStart.setColumns(8);
        this.m_currStart.setEnabled(false);
        p.add((Component)this.m_currStart, gbc);
        this.m_currEnd = new JTextField();
        CurrentUpdate cend = new CurrentUpdate(this.m_currEnd);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.m_typeEnd = this.createTypeGroup(p, gbc, cend);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.End.Label")), gbc);
        gbc.gridx = 1;
        this.m_end = new JTextField();
        this.m_end.addActionListener(cend);
        this.m_end.setColumns(16);
        p.add((Component)this.m_end, gbc);
        ++gbc.gridx;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.Current.Label")), gbc);
        ++gbc.gridx;
        this.m_currEnd.setColumns(8);
        this.m_currEnd.setEnabled(false);
        p.add((Component)this.m_currEnd, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        this.createOccurance(p, gbc, cstart, cend);
        ++gbc.gridy;
        p.add((Component)new JLabel(this.m_resource.getString("MarkForm.Note.Label")), gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        this.m_note = new JEditorPane();
        JScrollPane scroll = new JScrollPane(this.m_note);
        scroll.setPreferredSize(new Dimension(80, 80));
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(31);
        p.add((Component)scroll, gbc);
        gbc.fill = 0;
        this.add((Component)p, "Center");
        this.m_actions = new FormAction((Form)this, 3);
        this.add((Component)this.m_actions, "South");
    }

    public void performApply() {
    }

    public void performCancel() {
        SwingUtilities.getWindowAncestor(this).dispose();
        this.m_rule = null;
    }

    public void performOk() {
        if (StringHelper.isEmpty((String)this.m_name.getText())) {
            JOptionPane.showMessageDialog(this, this.m_resource.getString("MarkForm.NoId.Message"));
            return;
        }
        SwingUtilities.getWindowAncestor(this).dispose();
        this.m_rule.setId(this.m_name.getText());
        this.m_rule.setStart(this.m_start.getText(), this.m_typeStart.getSelection().getActionCommand());
        this.m_rule.setEnd(this.m_end.getText(), this.m_typeEnd.getSelection().getActionCommand());
        this.m_rule.setNote(this.m_note.getText());
        if (!StringHelper.isEmpty((String)this.m_occurValue.getText())) {
            this.m_rule.setOccurance(this.m_occurance.getSelection().getActionCommand(), (String)this.m_occurStart.getSelectedItem(), (String)this.m_occurType.getSelectedItem(), this.m_occurValue.getText());
        }
    }

    public void performUndo() {
    }

    public void setDocument(BinaryDocument doc) {
        this.m_document = doc;
    }

    public void setMarkRule(MarkRule rule) {
        this.m_rule = rule;
        this.m_start.setText(rule.getStart().getValue());
        this.selectGroup(this.m_typeStart, rule.getStart().getType());
        this.m_end.setText(rule.getEnd().getValue());
        this.selectGroup(this.m_typeEnd, rule.getEnd().getType());
    }

    public MarkRule getMarkRule() {
        return this.m_rule;
    }

    public synchronized void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
        JRootPane p = this.getRootPane();
        p.setDefaultButton(this.m_actions.getButton(1));
        this.m_name.requestFocus();
    }

    private void selectGroup(ExtButtonGroup grp, String ac) {
        for (AbstractButton b : grp) {
            if (!ac.equals(b.getActionCommand())) continue;
            grp.setSelected(b.getModel(), true);
            break;
        }
    }

    private ExtButtonGroup createTypeGroup(JPanel p, GridBagConstraints gbc, CurrentUpdate cu) {
        ExtButtonGroup grp = new ExtButtonGroup();
        JPanel gp = new JPanel();
        gp.setBorder(BorderFactory.createTitledBorder(this.m_resource.getString("MarkForm.Type.Title")));
        JRadioButton pos = new JRadioButton(this.m_resource.getString("MarkForm.Type.Position"));
        pos.addActionListener(cu);
        pos.setActionCommand("POS");
        gp.add((Component)pos, gbc);
        grp.add((AbstractButton)pos);
        JRadioButton adr = new JRadioButton(this.m_resource.getString("MarkForm.Type.Address"));
        adr.addActionListener(cu);
        adr.setActionCommand("ADR");
        gp.add((Component)adr, gbc);
        grp.add((AbstractButton)adr);
        JRadioButton val = new JRadioButton(this.m_resource.getString("MarkForm.Type.Value"));
        val.addActionListener(cu);
        val.setActionCommand("VAL");
        gp.add((Component)val, gbc);
        grp.add((AbstractButton)val);
        JRadioButton fnc = new JRadioButton(this.m_resource.getString("MarkForm.Type.Function"));
        fnc.addActionListener(cu);
        fnc.setActionCommand("FNC");
        gp.add(fnc);
        grp.add((AbstractButton)fnc);
        p.add((Component)gp, gbc);
        grp.setSelected(pos.getModel(), true);
        return grp;
    }

    private void createOccurance(JPanel p, GridBagConstraints gbc, CurrentUpdate cu0, CurrentUpdate cu1) {
        ExtButtonGroup grp = new ExtButtonGroup();
        JPanel gp = new JPanel();
        gp.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridy = 0;
        gbc2.insets = new Insets(2, 2, 5, 2);
        gbc2.anchor = 17;
        gp.setBorder(BorderFactory.createTitledBorder(this.m_resource.getString("MarkForm.Occurance.Title")));
        JRadioButton pos = new JRadioButton(this.m_resource.getString("MarkForm.Occurance.First"));
        pos.addActionListener(cu0);
        pos.addActionListener(cu1);
        pos.setActionCommand("FIR");
        gp.add((Component)pos, gbc2);
        grp.add((AbstractButton)pos);
        JRadioButton adr = new JRadioButton(this.m_resource.getString("MarkForm.Occurance.Last"));
        adr.addActionListener(cu0);
        adr.addActionListener(cu1);
        adr.setActionCommand("LAS");
        gp.add((Component)adr, gbc2);
        grp.add((AbstractButton)adr);
        JRadioButton val = new JRadioButton(this.m_resource.getString("MarkForm.Occurance.All"));
        val.addActionListener(cu0);
        val.addActionListener(cu1);
        val.setActionCommand("ALL");
        gp.add((Component)val, gbc2);
        grp.add((AbstractButton)val);
        ++gbc2.gridy;
        this.m_occurStart = new JComboBox<String>(this.m_resource.getString("MarkForm.Occurance.StartList").split(","));
        this.m_occurStart.addActionListener(cu0);
        this.m_occurStart.addActionListener(cu1);
        gp.add((Component)this.m_occurStart, gbc2);
        this.m_occurType = new JComboBox<String>(this.m_resource.getString("MarkForm.Occurance.TypeList").split(","));
        this.m_occurType.addActionListener(cu0);
        this.m_occurType.addActionListener(cu1);
        gp.add((Component)this.m_occurType, gbc2);
        this.m_occurValue = new JTextField();
        this.m_occurValue.setColumns(12);
        this.m_occurValue.addActionListener(cu0);
        this.m_occurValue.addActionListener(cu1);
        gp.add((Component)this.m_occurValue, gbc2);
        p.add((Component)gp, gbc);
        grp.setSelected(pos.getModel(), true);
        this.m_occurance = grp;
    }

    String getCurrent(String val, String typ, String occVal, int occ, int pos, int occType) {
        if ("POS".equals(typ)) {
            return val;
        }
        if ("ADR".equals(typ)) {
            try {
                int idx = Integer.parseInt(val);
                return String.valueOf(this.m_document.getBytes(idx, 1)[0]);
            }
            catch (BadLocationException blex) {}
        } else if ("VAL".equals(typ)) {
            byte idx = (byte)Integer.parseInt(val);
            byte[] b = new byte[]{idx};
            int result = FindTask.find(this.m_document, b, 0, this.m_document.getLength());
            return String.valueOf(result);
        }
        return null;
    }

    public BinaryDocument getDocument() {
        return this.m_document;
    }

    class CurrentUpdate
    implements ActionListener {
        private boolean m_start;
        private JTextField m_field;

        CurrentUpdate(JTextField field) {
            this.m_field = field;
            this.m_start = this.m_field == MarkPane.this.m_currStart;
        }

        public void actionPerformed(ActionEvent e) {
            String typ;
            String val;
            int occ = -1;
            int pos = -1;
            int occType = -1;
            if (this.m_start) {
                val = MarkPane.this.m_start.getText();
                typ = MarkPane.this.m_typeStart.getSelection().getActionCommand();
            } else {
                val = MarkPane.this.m_end.getText();
                typ = MarkPane.this.m_typeEnd.getSelection().getActionCommand();
            }
            String occVal = MarkPane.this.m_occurValue.getText();
            if (StringHelper.isEmpty((String)occVal)) {
                String sOcc = MarkPane.this.m_occurance.getSelection().getActionCommand();
                occ = sOcc.equals("FIR") ? -1 : (sOcc.equals("LAS") ? 1 : 0);
                pos = MarkPane.this.m_occurStart.getSelectedIndex();
                occType = MarkPane.this.m_occurType.getSelectedIndex();
            }
            this.m_field.setText(MarkPane.this.getCurrent(val, typ, occVal, occ, pos, occType));
        }
    }

    class TextVerify
    extends InputVerifier {
        CalculateParser m_calculate = new CalculateParser();

        public boolean verify(JComponent input) {
            int location;
            block9: {
                String value;
                JTextComponent tc = (JTextComponent)input;
                ExtButtonGroup xb = MarkPane.this.m_typeStart;
                if (tc == MarkPane.this.m_end) {
                    xb = MarkPane.this.m_typeEnd;
                }
                if (StringHelper.isEmpty((String)(value = tc.getText()))) {
                    return false;
                }
                String ac = xb.getSelection().getActionCommand();
                location = MarkPane.this.m_document.getLength() + 1;
                try {
                    if ("HEX".equals(ac)) {
                        location = Integer.decode("0x" + value);
                        break block9;
                    }
                    if (this.m_calculate.isCalculation(value)) {
                        try {
                            location = (int)this.m_calculate.parsedouble(value);
                            if (location != -1 && location < MarkPane.this.m_document.getLength()) {
                                tc.setText(String.valueOf(location));
                            }
                            break block9;
                        }
                        catch (ParseException pex) {}
                        break block9;
                    }
                    location = Integer.parseInt(value);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            return location < MarkPane.this.m_document.getLength();
        }
    }
}

