/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.BinaryElement;

public class BinaryIOKit {
    public static final int BLOCK_SIZE = 4096;
    public static final int ELEMENT_OLD = 0;
    public static final int ELEMENT_ALTER = 1;
    public static final int ELEMENT_MEMORY = 2;
    private Stack m_cachedBlock = new Stack();
    private File m_file;
    private File m_tmpFile;
    private int m_mode;

    public void write(OutputStream os, BinaryDocument doc, int offset, int len) throws IOException, BadLocationException {
        os.write(doc.getBytes(offset, len));
    }

    public void read(InputStream is, BinaryDocument doc, int offset) throws IOException, BadLocationException {
        this.read(is, doc, offset, Integer.MAX_VALUE);
        doc.documentUpdated();
    }

    public void open(File f, BinaryDocument doc) throws IOException, BadLocationException {
        BinaryElement be;
        int idx;
        BinaryElement root = (BinaryElement)doc.getDefaultRootElement();
        this.m_file = f;
        FileInputStream fis = new FileInputStream(f);
        int blocks = (int)f.length() / 4096;
        for (int i = 0; i < blocks; ++i) {
            if (i < 3) {
                this.read(fis, doc, i * 4096, 4096);
                this.m_cachedBlock.push(root.getElement(root.getElementCount() - 1));
                continue;
            }
            idx = root.getElementIndex(i * 4096 + 1);
            if (idx == -1) {
                be = new BinaryElement((Document)doc, null, 4096);
                root.addElement(be);
                continue;
            }
            be = (BinaryElement)root.getElement(idx);
        }
        int rlen = (int)f.length() - blocks * 4096;
        if (rlen > 0) {
            idx = root.getElementIndex((blocks + 1) * 4096 + 1);
            if (idx == -1) {
                be = new BinaryElement((Document)doc, null, rlen);
                root.addElement(be);
            } else {
                be = (BinaryElement)root.getElement(idx);
                be.setLength(rlen);
            }
            if (blocks < 3) {
                this.read(fis, doc, be.getStartOffset(), rlen);
                this.m_cachedBlock.push(root.getElement(root.getElementCount() - 1));
            }
        }
        doc.documentUpdated();
        fis.close();
    }

    public void save(File f, BinaryDocument doc) throws IOException, BadLocationException {
        BinaryElement root = (BinaryElement)doc.getDefaultRootElement();
        File tmpFile = File.createTempFile("_thx", ".dmp");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        for (int i = 0; i < root.getElementCount(); ++i) {
            BinaryElement be = (BinaryElement)root.getElement(i);
            this.write(fos, doc, be.getStartOffset(), be.getEndOffset() - be.getStartOffset());
        }
        fos.close();
        if (f.exists()) {
            f.delete();
        }
        if (!tmpFile.renameTo(f)) {
            FileChannel srcChannel = new FileInputStream(tmpFile).getChannel();
            FileChannel dstChannel = new FileOutputStream(f).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            tmpFile.delete();
        }
        this.m_file = f;
        doc.documentUpdated();
    }

    protected void writeBlock(BinaryElement be) throws IOException {
        if (this.m_tmpFile == null) {
            this.m_tmpFile = File.createTempFile("thex", "dmp");
            this.m_tmpFile.deleteOnExit();
        }
        RandomAccessFile ras = new RandomAccessFile(this.m_tmpFile, "rw");
        ras.seek(be.getStartOffset());
        ras.write(be.getBytes());
        ras.close();
    }

    protected void releaseBlock(BinaryElement be) {
        be.setState(0);
        be.setBytes(null);
    }

    public void readBlock(BinaryElement be) throws IOException {
        if (be.getState() == 0) {
            int idx = be.getDocument().getDefaultRootElement().getElementIndex(be.getStartOffset() + 1);
            byte[] b = new byte[be.getEndOffset() - be.getStartOffset()];
            RandomAccessFile ras = new RandomAccessFile(this.m_file, "rw");
            ras.seek(idx * 4096);
            ras.read(b);
            ras.close();
            be.setBytes(b);
        } else if (be.getState() == 1) {
            byte[] b = new byte[be.getEndOffset() - be.getStartOffset()];
            RandomAccessFile ras = new RandomAccessFile(this.m_tmpFile, "rw");
            ras.seek(be.getStartOffset());
            ras.read(b);
            ras.close();
            be.setBytes(b);
        }
        be.setState(2);
        this.m_cachedBlock.push(be);
    }

    private void read(InputStream is, BinaryDocument doc, int offset, int len) throws IOException, BadLocationException {
        byte[] b = new byte[4096];
        int rlen = 0;
        for (int tlen = 0; tlen < len && (rlen = is.read(b)) != -1; tlen += rlen) {
            BinaryElement be;
            BinaryElement root = (BinaryElement)doc.getDefaultRootElement();
            int idx = root.getElementIndex(offset + tlen + 1);
            if (idx == -1) {
                be = new BinaryElement((Document)doc, null, rlen);
                root.addElement(be);
            } else {
                be = (BinaryElement)root.getElement(idx);
                be.setLength(rlen);
            }
            be.setBytes(b, 0, rlen);
            be.setState(2);
        }
    }

    public void setBlockData(BinaryElement be) throws IOException, BadLocationException {
        BinaryElement old = (BinaryElement)this.m_cachedBlock.firstElement();
        if (old.getState() == 1) {
            this.writeBlock(old);
        } else {
            this.releaseBlock(old);
        }
        this.m_cachedBlock.remove(old);
        this.readBlock(be);
    }

    public File getFile() {
        return this.m_file;
    }
}

