/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.gui;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class PseudoHighlighter
extends LayeredHighlighter {
    private TreeSet<BinaryHighlight> m_segments = new TreeSet();
    private JTextComponent m_text;
    private boolean m_active;
    private boolean m_alwaysPaint;

    public PseudoHighlighter() {
        this(false);
    }

    public PseudoHighlighter(boolean alwaysPaint) {
        this.m_alwaysPaint = alwaysPaint;
    }

    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        if (!this.m_alwaysPaint && editor.isVisible() && editor.hasFocus()) {
            this.m_active = false;
            return;
        }
        this.m_active = true;
        Rectangle a = viewBounds.getBounds();
        int columns = (Integer)editor.getClientProperty("lastColumn");
        for (BinaryHighlight bs : this.m_segments) {
            p0 = Math.min(bs.getStartOffset(), bs.getEndOffset());
            p1 = Math.max(bs.getStartOffset(), bs.getEndOffset());
            try {
                if (p0 != p1) {
                    g.setColor(editor.getSelectionColor());
                    Rectangle r0 = view.modelToView(p0, viewBounds, Position.Bias.Forward).getBounds();
                    Rectangle r1 = view.modelToView(p1 - 1, viewBounds, Position.Bias.Forward).getBounds();
                    a.width = columns * r0.width;
                    if (r0.y == r1.y) {
                        r0 = r0.union(r1);
                        g.fillRect(r0.x, r0.y, r0.width, r0.height);
                        continue;
                    }
                    g.fillRect(r0.x, r0.y, a.width - a.x - r0.x, r0.height);
                    g.fillRect(0, r0.y + r0.height, a.width - a.x, r1.y - (r0.y + r0.height));
                    g.fillRect(0, r1.y, r1.x + r1.width, r1.height);
                    continue;
                }
                Rectangle r1 = view.modelToView(p1, viewBounds, Position.Bias.Forward).getBounds();
                g.setColor(editor.getCaretColor());
                int paintWidth = 1;
                r1.x -= paintWidth >> 1;
                g.fillRect(r1.x, r1.y, paintWidth, r1.height);
            }
            catch (BadLocationException blex) {}
        }
    }

    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
        BinaryHighlight h = new BinaryHighlight(p0, p1);
        this.m_segments.add(h);
        return h;
    }

    public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
        if (this.m_segments.isEmpty()) {
            this.addHighlight(Math.min(p0, p1), Math.max(p0, p1), null);
            return;
        }
        BinaryHighlight h = this.m_segments.first();
        h.m_start = p0;
        h.m_end = p1;
    }

    public void deinstall(JTextComponent c) {
        this.m_text = null;
    }

    public Highlighter.Highlight[] getHighlights() {
        return this.m_segments.toArray(new Highlighter.Highlight[this.m_segments.size()]);
    }

    public void install(JTextComponent c) {
        this.m_text = c;
    }

    public void paint(Graphics g) {
    }

    public void removeAllHighlights() {
        this.m_segments.clear();
    }

    public void removeHighlight(Object tag) {
        this.m_segments.remove(tag);
    }

    public PseudoHighlighter shareHighlighter() {
        PseudoHighlighter p = new PseudoHighlighter();
        p.m_segments = this.m_segments;
        p.m_alwaysPaint = this.m_alwaysPaint;
        return p;
    }

    public Highlighter.Highlight findHighlight(int dot, Position.Bias b) {
        BinaryHighlight mark = new BinaryHighlight(dot, dot);
        if (Position.Bias.Forward.equals(b)) {
            return this.m_segments.tailSet(mark).last();
        }
        return this.m_segments.headSet(mark).first();
    }

    public boolean isActive() {
        return this.m_active;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryHighlight
    implements Highlighter.Highlight,
    Comparable<BinaryHighlight> {
        private int m_start;
        private int m_end;

        public BinaryHighlight(int start, int end) {
            this.m_start = start;
            this.m_end = end;
        }

        @Override
        public int getEndOffset() {
            return this.m_end;
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return this.m_start;
        }

        @Override
        public int compareTo(BinaryHighlight o) {
            return this.getStartOffset() - o.getStartOffset();
        }
    }
}

