/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentListener;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;
import org.brains2b.swingext.gui.ExtButtonGroup;
import org.brains2b.swingext.mask.CalculateParser;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.util.StringHelper;

public class GotoPane
extends JPanel
implements Form {
    private JLabel m_message;
    private ExtButtonGroup m_type;
    private JComboBox m_text;
    private ResourceBundle m_resource;
    private int m_location;
    private int m_length;
    private FormAction m_actions;

    public GotoPane() {
        this.init();
    }

    private void init() {
        this.m_resource = ResourceBundle.getBundle("org.brains2b.thex.resource.thex");
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.m_message = new JLabel();
        gbc.gridwidth = 3;
        p.add((Component)this.m_message, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.m_type = new ExtButtonGroup();
        JRadioButton dec = new JRadioButton(this.m_resource.getString("GotoForm.Type.Dec"));
        dec.setActionCommand("DEC");
        dec.setMnemonic('d');
        p.add((Component)dec, gbc);
        this.m_type.add((AbstractButton)dec);
        ++gbc.gridx;
        JRadioButton hex = new JRadioButton(this.m_resource.getString("GotoForm.Type.Hex"));
        hex.setMnemonic('h');
        hex.setActionCommand("HEX");
        p.add((Component)hex, gbc);
        this.m_type.add((AbstractButton)hex);
        ++gbc.gridx;
        JRadioButton func = new JRadioButton(this.m_resource.getString("GotoForm.Type.Func"));
        func.setMnemonic('f');
        func.setActionCommand("FUN");
        p.add((Component)func, gbc);
        this.m_type.add((AbstractButton)func);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        this.m_text = new JComboBox();
        this.m_text.setEditable(true);
        ((JTextComponent)this.m_text.getEditor().getEditorComponent()).setInputVerifier(new TextVerify());
        p.add((Component)this.m_text, gbc);
        this.add((Component)p, "Center");
        this.m_actions = new FormAction((Form)this, 3);
        this.add((Component)this.m_actions, "South");
    }

    public void performApply() {
    }

    public void performCancel() {
        SwingUtilities.getWindowAncestor(this).dispose();
        this.m_location = -1;
    }

    public void performOk() {
        SwingUtilities.getWindowAncestor(this).dispose();
        String ac = this.m_type.getSelection().getActionCommand();
        this.m_location = -1;
        String s = (String)this.m_text.getSelectedItem();
        if ("HEX".equals(ac)) {
            if (!StringHelper.isEmpty((String)s)) {
                this.m_location = Integer.decode("0x" + s);
            }
        } else if (!StringHelper.isEmpty((String)s)) {
            this.m_location = Integer.valueOf(s);
        }
        if (this.m_location > 0) {
            this.m_text.addItem(s);
        }
    }

    public void performUndo() {
    }

    public void setDocument(BinaryDocument doc) {
        this.m_length = doc.getLength();
        String msg = this.m_resource.getString("GotoForm.Message");
        this.m_message.setText(MessageFormat.format(msg, String.valueOf(this.m_length)));
        this.m_type.setSelected(((AbstractButton)this.m_type.getElements().nextElement()).getModel(), true);
    }

    public synchronized void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
        JRootPane p = this.getRootPane();
        p.setDefaultButton(this.m_actions.getButton(1));
        this.m_text.requestFocus();
    }

    public int getPosition() {
        return this.m_location;
    }

    class TextVerify
    extends InputVerifier {
        CalculateParser m_calculate = new CalculateParser();

        public boolean verify(JComponent input) {
            int location;
            block8: {
                JTextComponent tc = (JTextComponent)input;
                String value = tc.getText();
                if (StringHelper.isEmpty((String)value)) {
                    return false;
                }
                String ac = GotoPane.this.m_type.getSelection().getActionCommand();
                location = GotoPane.this.m_length + 1;
                try {
                    if ("HEX".equals(ac)) {
                        location = Integer.decode("0x" + value);
                        break block8;
                    }
                    if (this.m_calculate.isCalculation(value)) {
                        try {
                            location = (int)this.m_calculate.parsedouble(value);
                            if (location != -1 && location < GotoPane.this.m_length) {
                                tc.setText(String.valueOf(location));
                            }
                            break block8;
                        }
                        catch (ParseException pex) {}
                        break block8;
                    }
                    location = Integer.parseInt(value);
                }
                catch (NumberFormatException nfex) {
                    // empty catch block
                }
            }
            return location < GotoPane.this.m_length;
        }
    }
}

