/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Position;
import org.brains2b.swingext.form.Form;
import org.brains2b.swingext.form.FormAction;
import org.brains2b.swingext.gui.ExtButtonGroup;
import org.brains2b.util.HexHelper;
import org.brains2b.util.StringHelper;

public class FindPane
extends JPanel
implements Form {
    private JLabel m_message;
    private ExtButtonGroup m_type;
    private ExtButtonGroup m_scope;
    private ExtButtonGroup m_direct;
    private JComboBox m_text;
    private ResourceBundle m_resource;
    private int m_location;
    private FormAction m_actions;
    private boolean m_findAll;
    private byte[] m_byte;

    public FindPane() {
        this.init();
    }

    private void init() {
        this.m_resource = ResourceBundle.getBundle("org.brains2b.thex.resource.thex");
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.m_message = new JLabel();
        this.m_message.setText(this.m_resource.getString("FindForm.Message"));
        gbc.gridwidth = 3;
        p.add((Component)this.m_message, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.m_type = new ExtButtonGroup();
        JRadioButton hex = new JRadioButton(this.m_resource.getString("GotoForm.Type.Hex"));
        hex.setMnemonic('h');
        hex.setActionCommand("HEX");
        p.add((Component)hex, gbc);
        this.m_type.add((AbstractButton)hex);
        ++gbc.gridx;
        JRadioButton asc = new JRadioButton(this.m_resource.getString("FindForm.Type.Asc"));
        asc.setMnemonic('a');
        asc.setActionCommand("ASC");
        p.add((Component)asc, gbc);
        this.m_type.add((AbstractButton)asc);
        ++gbc.gridx;
        JRadioButton func = new JRadioButton(this.m_resource.getString("GotoForm.Type.Func"));
        func.setMnemonic('f');
        func.setActionCommand("FUN");
        p.add((Component)func, gbc);
        this.m_type.add((AbstractButton)func);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        this.m_text = new JComboBox();
        this.m_text.setEditable(true);
        p.add((Component)this.m_text, gbc);
        this.add((Component)p, "Center");
        JPanel scope = new JPanel(new GridLayout(2, 1));
        scope.setBorder(BorderFactory.createTitledBorder(this.m_resource.getString("FindForm.Scope")));
        this.m_scope = new ExtButtonGroup();
        JRadioButton all = new JRadioButton(this.m_resource.getString("FindForm.Scope.All"));
        all.setMnemonic('l');
        all.setActionCommand("ALL");
        scope.add((Component)all, gbc);
        this.m_scope.add((AbstractButton)all);
        JRadioButton sel = new JRadioButton(this.m_resource.getString("FindForm.Scope.Selection"));
        sel.setMnemonic('s');
        sel.setActionCommand("SEL");
        scope.add((Component)sel, gbc);
        this.m_scope.add((AbstractButton)sel);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        p.add((Component)scope, gbc);
        JPanel direct = new JPanel(new GridLayout(2, 1));
        direct.setBorder(BorderFactory.createTitledBorder(this.m_resource.getString("FindForm.Direction")));
        this.m_direct = new ExtButtonGroup();
        JRadioButton forward = new JRadioButton(this.m_resource.getString("FindForm.Direction.Forward"));
        forward.setMnemonic('r');
        forward.setActionCommand("FWD");
        direct.add((Component)forward, gbc);
        this.m_direct.add((AbstractButton)forward);
        JRadioButton backward = new JRadioButton(this.m_resource.getString("FindForm.Direction.Backward"));
        backward.setMnemonic('b');
        backward.setActionCommand("BWD");
        direct.add((Component)backward, gbc);
        this.m_direct.add((AbstractButton)backward);
        gbc.gridx += 2;
        gbc.gridwidth = 2;
        p.add((Component)direct, gbc);
        this.m_actions = new FormAction((Form)this, 7);
        this.add((Component)this.m_actions, "South");
        this.m_scope.setSelected(((AbstractButton)this.m_scope.getElements().nextElement()).getModel(), true);
        this.m_direct.setSelected(((AbstractButton)this.m_direct.getElements().nextElement()).getModel(), true);
        this.m_type.setSelected(((AbstractButton)this.m_type.getElements().nextElement()).getModel(), true);
    }

    public void performApply() {
        this.performOk();
        this.m_findAll = true;
    }

    public void performCancel() {
        SwingUtilities.getWindowAncestor(this).dispose();
        this.m_location = -1;
    }

    public void performOk() {
        this.m_findAll = false;
        SwingUtilities.getWindowAncestor(this).dispose();
        String ac = this.m_type.getSelection().getActionCommand();
        String value = (String)this.m_text.getSelectedItem();
        if (StringHelper.isEmpty((String)value)) {
            this.m_byte = null;
            return;
        }
        this.m_byte = null;
        if ("ASC".equals(ac)) {
            try {
                this.m_byte = value.getBytes("ISO-8859-1");
            }
            catch (Exception exception) {}
        } else if ("HEX".equals(ac)) {
            this.m_byte = HexHelper.decode((String)value);
        }
    }

    public void performUndo() {
    }

    public synchronized void addComponentListener(ComponentListener l) {
        super.addComponentListener(l);
        JRootPane p = this.getRootPane();
        p.setDefaultButton(this.m_actions.getButton(1));
        this.m_text.requestFocus();
    }

    public byte[] getBytes() {
        return this.m_byte;
    }

    public Position.Bias getDirection() {
        return "FWD".equals(this.m_direct.getSelection().getActionCommand()) ? Position.Bias.Forward : Position.Bias.Backward;
    }

    public boolean isSelectionOnly() {
        return "SEL".equals(this.m_scope.getSelection().getActionCommand());
    }

    public void setDirection(Position.Bias direction) {
        Enumeration enu = this.m_direct.getElements();
        if (direction == Position.Bias.Backward) {
            this.m_direct.setSelected(((AbstractButton)enu.nextElement()).getModel(), true);
        } else {
            enu.nextElement();
            this.m_direct.setSelected(((AbstractButton)enu.nextElement()).getModel(), true);
        }
    }

    public void setSelectionOnly(boolean select) {
        Enumeration enu = this.m_scope.getElements();
        if (!select) {
            this.m_scope.setSelected(((AbstractButton)enu.nextElement()).getModel(), true);
        } else {
            enu.nextElement();
            this.m_scope.setSelected(((AbstractButton)enu.nextElement()).getModel(), true);
        }
    }

    public boolean isFindAll() {
        return this.m_findAll;
    }

    public void setType(String type) {
        for (AbstractButton b : this.m_type) {
            if (!type.equals(b.getActionCommand())) continue;
            this.m_type.setSelected(b.getModel(), true);
            break;
        }
    }
}

