/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.UnsupportedEncodingException;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.brains2b.log.Logger;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.PseudoCaretComponent;

public class ViewAscii
extends View {
    private int m_height = -1;
    private int m_width = -1;

    public ViewAscii(Element element) {
        super(element);
    }

    public float getPreferredSpan(int axis) {
        if (axis == 0) {
            return 2080.0f;
        }
        if (axis == 1) {
            return 480.0f;
        }
        return 0.0f;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        BinaryDocument doc = (BinaryDocument)this.getElement().getDocument();
        JTextComponent tc = (JTextComponent)this.getContainer();
        Rectangle vr = a.getBounds();
        int column = vr.width / this.m_width;
        if (tc != null && tc.getClientProperty("lastColumn") != null) {
            column = (Integer)tc.getClientProperty("lastColumn");
        }
        int row = doc.getLength() / column;
        int x = pos % column * this.m_width;
        int y = vr.y + pos / column * this.m_height;
        return new Rectangle(x, y, this.m_width, this.m_height);
    }

    public void paint(Graphics g, Shape allocation) {
        this.calculateMetrics(g);
        BinaryDocument doc = (BinaryDocument)this.getElement().getDocument();
        g.setColor(Color.black);
        try {
            JTextComponent tc = (JTextComponent)this.getContainer();
            Caret caret = tc.getCaret();
            Rectangle r = allocation.getBounds();
            Rectangle vr = allocation.getBounds();
            if (tc != null) {
                vr = tc.getVisibleRect();
            }
            int p0 = Math.min(caret.getMark(), caret.getDot());
            int p1 = Math.max(caret.getMark(), caret.getDot());
            int st = Math.max(0, this.viewToModel((float)vr.getX(), (float)vr.getY(), allocation, new Position.Bias[]{Position.Bias.Forward}));
            int en = this.viewToModel((float)(vr.getX() + vr.getWidth()), (float)(vr.getY() + vr.getHeight()), allocation, new Position.Bias[]{Position.Bias.Forward});
            char[] c = new String(doc.getBytes(st, Math.min(doc.getLength(), en - st)), "ISO-8859-1").toCharArray();
            int column = (Integer)tc.getClientProperty("lastColumn");
            int row = c.length / column;
            int len = Math.min(column, c.length);
            if (tc.getHighlighter() instanceof LayeredHighlighter) {
                ((LayeredHighlighter)tc.getHighlighter()).paintLayeredHighlights(g, p0, p1, allocation, tc, this);
            }
            ((PseudoCaretComponent)((Object)tc)).getPseudoHighlighter().paintLayeredHighlights(g, p0, p1, allocation, tc, this);
            ((PseudoCaretComponent)((Object)tc)).getFindHighlighter().paintLayeredHighlights(g, st, en, allocation, tc, this);
            g.setColor(tc.getForeground());
            vr.y = Math.max(0, vr.y / 14 * 14);
            for (int j = 0; j <= row; ++j) {
                for (int i = 0; i < len && j * len + i < c.length; ++i) {
                    g.drawChars(c, j * len + i, 1, vr.x + i * this.m_width, vr.y + this.m_height + j * this.m_height);
                }
            }
        }
        catch (BadLocationException blex) {
            Logger.printException((Exception)blex);
        }
        catch (UnsupportedEncodingException useex) {
            // empty catch block
        }
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        int result = 0;
        BinaryDocument doc = (BinaryDocument)this.getElement().getDocument();
        JTextComponent tc = (JTextComponent)this.getContainer();
        Rectangle vr = a.getBounds();
        int column = vr.width / this.m_width;
        if (tc != null && tc.getClientProperty("lastColumn") != null) {
            column = (Integer)tc.getClientProperty("lastColumn");
        }
        int cpos = Math.round(x / (float)this.m_width);
        int rpos = (int)Math.floor((double)y / (double)this.m_height);
        result = rpos * column + cpos;
        if (result > doc.getLength()) {
            result = doc.getLength();
        }
        return result;
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        this.getContainer().repaint();
    }

    public void calculateMetrics(Graphics g) {
        if (this.m_height == -1 || this.m_width == -1) {
            Font f = g.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            this.m_width = f.getSize();
            this.m_height = fm.getHeight();
        }
    }
}

