/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.UndoManager;
import org.brains2b.swingext.dialog.DialogHelper;
import org.brains2b.swingext.gui.GuiItemFactory;
import org.brains2b.swingext.gui.StatusBar;
import org.brains2b.thex.AsciiEditor;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.BinaryEditor;
import org.brains2b.thex.ByteColumnHeader;
import org.brains2b.thex.ByteRowHeader;
import org.brains2b.thex.HexCaret;
import org.brains2b.thex.HexEditorMap;
import org.brains2b.thex.PseudoCaretComponent;
import org.brains2b.thex.gui.FindPane;
import org.brains2b.thex.gui.GotoPane;
import org.brains2b.thex.gui.PseudoHighlighter;
import org.brains2b.thex.io.BinaryIOKit;
import org.brains2b.thex.mark.MarkManager;
import org.brains2b.thex.tasks.FindTask;

public class HexEditor
extends JPanel
implements ActionListener {
    private static GotoPane m_gotoPane;
    private static FindPane m_findPane;
    private static JPopupMenu m_popup;
    private JSplitPane m_split;
    private BinaryEditor m_bEdit;
    private AsciiEditor m_aEdit;
    private StatusBar m_status;
    private UndoManager m_manager;
    private String m_title;
    private ResourceBundle m_resource;
    private Map<String, MarkManager> m_plugins;

    public HexEditor() {
        this.init();
    }

    private void init() {
        this.m_resource = ResourceBundle.getBundle("org.brains2b.thex.resource.thex");
        this.m_manager = new UndoManager();
        this.setLayout(new BorderLayout());
        this.setActionMap((ActionMap)((Object)new HexEditorMap(this)));
        this.m_split = new JSplitPane();
        this.m_split.setOrientation(1);
        this.add((Component)this.m_split, "Center");
        PopupHandler popup = new PopupHandler();
        ComponentSynchronize cs = new ComponentSynchronize();
        StatusHandler sh = new StatusHandler();
        this.addComponentListener(cs);
        PseudoHighlighter pseudo = new PseudoHighlighter();
        PseudoHighlighter find = new PseudoHighlighter(true);
        BinaryEditor be = new BinaryEditor();
        be.setCaret(new HexCaret());
        be.setPseudoHighlighter(pseudo);
        be.setFindHighligter(find);
        be.addPropertyChangeListener("lastRow", cs);
        be.addCaretListener(sh);
        be.addCaretListener(cs);
        be.addKeyListener(sh);
        be.addMouseListener(popup);
        be.getDocument().addUndoableEditListener(sh);
        be.getDocument().addUndoableEditListener(this.m_manager);
        be.getDocument().addDocumentListener(sh);
        this.m_bEdit = be;
        JScrollPane sbe = new JScrollPane(be);
        sbe.setColumnHeaderView(new ByteColumnHeader(be));
        sbe.setRowHeaderView(new ByteRowHeader(be));
        sbe.setHorizontalScrollBarPolicy(31);
        sbe.setVerticalScrollBarPolicy(20);
        sbe.getVerticalScrollBar().addAdjustmentListener(cs);
        AsciiEditor te = new AsciiEditor((BinaryDocument)be.getDocument());
        te.setCaret(new HexCaret());
        te.setPseudoHighlighter(pseudo.shareHighlighter());
        te.setFindHighligter(find.shareHighlighter());
        te.addMouseListener(popup);
        te.addKeyListener(sh);
        te.addCaretListener(sh);
        te.addCaretListener(cs);
        this.m_aEdit = te;
        JScrollPane ste = new JScrollPane(te);
        ste.setColumnHeaderView(new ByteColumnHeader(be));
        ste.setHorizontalScrollBarPolicy(31);
        ste.setVerticalScrollBarPolicy(20);
        ste.getVerticalScrollBar().addAdjustmentListener(cs);
        this.m_split.setLeftComponent(sbe);
        be.addComponentListener(cs);
        this.m_split.setRightComponent(ste);
        this.m_status = new StatusBar();
        this.m_status.setInputStatus(91);
        this.add((Component)this.m_status, "South");
    }

    public void setBytes(byte[] b) {
        this.m_bEdit.setBytes(b);
    }

    public BinaryDocument getDocument() {
        return (BinaryDocument)this.m_bEdit.getDocument();
    }

    public BinaryIOKit getIoKit() {
        return this.getDocument().getIoKit();
    }

    public boolean isChanged() {
        return this.m_manager.canUndo();
    }

    public String toString() {
        if (this.m_title != null) {
            return this.m_title;
        }
        if (this.getIoKit().getFile() != null) {
            return this.getIoKit().getFile().getName();
        }
        return null;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void doLayout() {
        super.doLayout();
        this.m_bEdit.repaint();
        if (this.m_aEdit.isVisible()) {
            BinaryEditor tcl = this.m_bEdit;
            Integer height = (Integer)tcl.getClientProperty("lastRow");
            Dimension d = this.getSize();
            d.width -= this.m_split.getDividerSize() + ((JScrollPane)this.m_split.getLeftComponent()).getVerticalScrollBar().getWidth() * 2;
            d.height = height == null ? d.height : height;
            Dimension dl = (Dimension)d.clone();
            dl.width = dl.width * 33 / 50;
            Dimension dr = (Dimension)d.clone();
            dr.width = dr.width * 17 / 50;
            tcl.setPreferredSize(dl);
            AsciiEditor tcr = this.m_aEdit;
            tcr.setPreferredSize(dr);
            this.m_split.setDividerLocation(d.width * 33 / 50);
        } else {
            this.m_split.setDividerLocation(1.0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        JTextComponent t;
        String ac = e.getActionCommand();
        JTextComponent jTextComponent = t = this.m_bEdit.hasFocus() ? this.m_bEdit : this.m_aEdit;
        if (!this.m_bEdit.hasFocus() && !this.m_aEdit.hasFocus()) {
            JTextComponent jTextComponent2 = t = this.m_bEdit.getPseudoHighlighter().isActive() ? this.m_aEdit : this.m_bEdit;
        }
        if ("Edit.Undo".equals(ac) && this.m_manager.canUndo()) {
            this.m_manager.undo();
        } else if ("Edit.Redo".equals(ac) && this.m_manager.canRedo()) {
            this.m_manager.redo();
        } else if ("Edit.SelectAll".equals(ac)) {
            t.selectAll();
        } else if ("Edit.Cut".equals(ac)) {
            t.cut();
        } else if ("Edit.Copy".equals(ac)) {
            t.copy();
        } else if ("Edit.Paste".equals(ac)) {
            t.paste();
        } else if ("Edit.Find".equals(ac)) {
            ((PseudoCaretComponent)((Object)t)).getFindHighlighter().removeAllHighlights();
            this.showFind(t);
        } else if ("Edit.FindNext".equals(ac)) {
            this.find(t, Position.Bias.Forward);
        } else if ("Edit.FindPrev".equals(ac)) {
            this.find(t, Position.Bias.Backward);
        } else if ("Edit.Goto".equals(ac)) {
            this.showGoto(t);
        }
    }

    private void showFind(JTextComponent target) {
        if (m_findPane == null) {
            m_findPane = new FindPane();
        }
        m_findPane.setSelectionOnly(target.getCaret().getDot() != target.getCaret().getMark());
        m_findPane.setType(target == this.m_bEdit ? "HEX" : "ASC");
        DialogHelper.showDialog((Component)this, (Container)m_findPane, (String)this.m_resource.getString("FindForm.Title"));
        if (m_findPane.getBytes() != null) {
            int p0 = m_findPane.isSelectionOnly() ? target.getCaret().getMark() : 0;
            int p1 = m_findPane.isSelectionOnly() ? target.getCaret().getDot() : target.getDocument().getLength();
            FindTask task = new FindTask(target, m_findPane.getBytes(), p0, p1, m_findPane.getDirection(), m_findPane.isFindAll());
            Thread t = new Thread((Runnable)((Object)task));
            t.start();
        }
    }

    private void showGoto(JTextComponent target) {
        if (m_gotoPane == null) {
            m_gotoPane = new GotoPane();
        }
        m_gotoPane.setDocument(this.getDocument());
        DialogHelper.showDialog((Component)this, (Container)m_gotoPane, (String)this.m_resource.getString("GotoForm.Title"));
        int pos = m_gotoPane.getPosition();
        target.getCaret().setDot(pos);
    }

    private void find(JTextComponent target, Position.Bias bias) {
        if (m_findPane == null || ((PseudoCaretComponent)((Object)target)).getFindHighlighter().getHighlights().length == 0) {
            this.showFind(target);
        } else {
            Highlighter.Highlight h = ((PseudoCaretComponent)((Object)target)).getFindHighlighter().findHighlight(target.getCaret().getDot(), bias);
            if (h != null) {
                target.getCaret().setDot(h.getStartOffset());
                target.getCaret().moveDot(h.getEndOffset());
            } else if (!m_findPane.isFindAll()) {
                int p0 = target.getCaret().getMark();
                int p1 = target.getDocument().getLength();
                FindTask task = new FindTask(target, m_findPane.getBytes(), p0, p1, bias, m_findPane.isFindAll());
                Thread th = new Thread((Runnable)((Object)task));
                th.start();
            }
        }
    }

    public void setAsciiVisible(boolean b) {
        this.m_aEdit.setVisible(b);
    }

    public boolean isAsciiVisible() {
        return this.m_aEdit.isVisible();
    }

    JPopupMenu getPopupMenu() {
        if (m_popup == null) {
            m_popup = new JPopupMenu();
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Undo"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Redo"));
            m_popup.addSeparator();
            if (this.getActionMap().get("File.Save") != null) {
                GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("File.Save"));
                m_popup.addSeparator();
            }
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Cut"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Copy"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Paste"));
            m_popup.addSeparator();
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Find"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.FindNext"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.FindPrev"));
            GuiItemFactory.createMenuItem((JPopupMenu)m_popup, (Action)this.getActionMap().get("Edit.Goto"));
        }
        return m_popup;
    }

    class PopupHandler
    extends MouseAdapter {
        PopupHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            this.popup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.popup(e);
        }

        private void popup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTextComponent tc = (JTextComponent)e.getComponent();
                int pn = tc.viewToModel(e.getPoint());
                int p0 = Math.min(tc.getCaret().getDot(), tc.getCaret().getMark());
                int p1 = Math.max(tc.getCaret().getDot(), tc.getCaret().getMark());
                if (p0 > pn || p1 < pn) {
                    tc.getCaret().setDot(pn);
                }
                HexEditor.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class StatusHandler
    extends KeyAdapter
    implements CaretListener,
    UndoableEditListener,
    DocumentListener {
        private int lastLength = 0;

        StatusHandler() {
        }

        public void caretUpdate(CaretEvent e) {
            int p0 = Math.min(e.getMark(), e.getDot());
            int p1 = Math.max(1, Math.abs(e.getMark() - e.getDot()));
            HexEditor.this.m_status.setFileStatus(String.valueOf(p0));
            if (p1 <= 5) {
                try {
                    MessageFormat msg = new MessageFormat("Dec: {0}   Hex: {1}   Bin: {2}");
                    StringBuffer sb = new StringBuffer();
                    byte[] b = HexEditor.this.getDocument().getBytes(p0, p1);
                    long val = 0L;
                    for (int i = b.length - 1; i >= 0; --i) {
                        val = (long)((double)val + (double)(b[i] >= 0 ? b[i] : b[i] + 256) * Math.pow(256.0, b.length - i - 1));
                    }
                    HexEditor.this.m_status.setStatusText(msg.format(new Object[]{Long.toString(val), Long.toHexString(val), Long.toBinaryString(val)}));
                }
                catch (BadLocationException blex) {}
            } else {
                MessageFormat msg = new MessageFormat("Select Start: {0}   End: {1} ");
                HexEditor.this.m_status.setStatusText(msg.format(new Object[]{p0, p0 + p1}));
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            HexEditor.this.m_status.setDocumentStatus(HexEditor.this.m_manager.canUndo() ? 1 : 0);
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 155) {
                if (91 == HexEditor.this.m_status.getInputStatus()) {
                    ((JTextComponent)((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getViewport().getView()).putClientProperty("replace", Boolean.TRUE);
                    ((JTextComponent)((JScrollPane)HexEditor.this.m_split.getRightComponent()).getViewport().getView()).putClientProperty("replace", Boolean.TRUE);
                    HexEditor.this.m_status.setInputStatus(92);
                } else {
                    ((JTextComponent)((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getViewport().getView()).putClientProperty("replace", Boolean.FALSE);
                    ((JTextComponent)((JScrollPane)HexEditor.this.m_split.getRightComponent()).getViewport().getView()).putClientProperty("replace", Boolean.FALSE);
                    HexEditor.this.m_status.setInputStatus(91);
                }
            }
        }

        public void changedUpdate(DocumentEvent e) {
            HexEditor.this.m_status.setInfoText("Size: " + e.getDocument().getLength());
            HexEditor.this.m_status.setDocumentStatus(HexEditor.this.m_manager.canUndo() ? 1 : 0);
        }

        public void insertUpdate(DocumentEvent e) {
            if (e.getOffset() == 0 && e.getLength() == e.getDocument().getLength()) {
                HexEditor.this.m_manager.discardAllEdits();
            }
            HexEditor.this.m_status.setInfoText("Size: " + e.getDocument().getLength());
            HexEditor.this.m_status.setDocumentStatus(HexEditor.this.m_manager.canUndo() ? 1 : 0);
        }

        public void removeUpdate(DocumentEvent e) {
            HexEditor.this.m_status.setInfoText("Size: " + e.getDocument().getLength());
            HexEditor.this.m_status.setDocumentStatus(HexEditor.this.m_manager.canUndo() ? 1 : 0);
        }
    }

    class ComponentSynchronize
    extends ComponentAdapter
    implements AdjustmentListener,
    PropertyChangeListener,
    CaretListener {
        ComponentSynchronize() {
        }

        public void componentResized(ComponentEvent e) {
            if (HexEditor.this == e.getComponent()) {
                HexEditor.this.doLayout();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getAdjustmentType() == 5) {
                return;
            }
            JScrollBar lsb = ((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getVerticalScrollBar();
            JScrollBar rsb = ((JScrollPane)HexEditor.this.m_split.getRightComponent()).getVerticalScrollBar();
            if (e.getSource() == rsb && lsb.getValue() != e.getValue()) {
                lsb.setValue(e.getValue());
            } else if (e.getSource() == lsb && rsb.getValue() != e.getValue()) {
                rsb.setValue(e.getValue());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getViewport().getView() == evt.getSource()) {
                JTextComponent tcl = (JTextComponent)evt.getSource();
                JTextComponent tcr = (JTextComponent)((JScrollPane)HexEditor.this.m_split.getRightComponent()).getViewport().getView();
                JComponent columnHeader = (JComponent)((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getColumnHeader().getView();
                columnHeader.putClientProperty("lastColumn", tcl.getClientProperty("lastColumn"));
                JComponent rowHeader = (JComponent)((JScrollPane)HexEditor.this.m_split.getLeftComponent()).getRowHeader().getView();
                rowHeader.putClientProperty("lastColumn", tcl.getClientProperty("lastColumn"));
                rowHeader.putClientProperty("lastRow", tcl.getClientProperty("lastRow"));
                tcr.putClientProperty("lastColumn", tcl.getClientProperty("lastColumn"));
                HexEditor.this.repaint();
            }
        }

        public void caretUpdate(CaretEvent e) {
            JTextComponent pcc = HexEditor.this.m_aEdit;
            if (e.getSource() == HexEditor.this.m_aEdit) {
                pcc = HexEditor.this.m_bEdit;
            }
            try {
                pcc.getPseudoHighlighter().changeHighlight(null, e.getMark(), e.getDot());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

