/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.brains2b.util.StringHelper;

public class ByteRowHeader
extends JComponent {
    JTextComponent m_editor;

    public ByteRowHeader(JTextComponent editor) {
        this.m_editor = editor;
        this.setPreferredSize(new Dimension(24, 24));
    }

    protected void paintComponent(Graphics g) {
        Font f = this.m_editor.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Integer height = (Integer)this.getClientProperty("lastRow");
        Integer width = (Integer)this.getClientProperty("lastColumn");
        if (height == null || width == null) {
            return;
        }
        int row = height / fm.getHeight();
        int max = this.m_editor.getDocument().getLength();
        int lenMax = String.valueOf(max).length();
        Dimension d = this.getPreferredSize();
        d.height = height;
        d.width = lenMax * f.getSize();
        Rectangle r = g.getClipBounds();
        if (this.getSize().width != d.width || this.getSize().height < d.height) {
            this.setPreferredSize(d);
            this.setSize(d);
        }
        for (int i = r.y / fm.getHeight(); i <= Math.min(row, (r.y + r.height) / fm.getHeight()); ++i) {
            char[] c = StringHelper.leftPad((String)String.valueOf(i * width), (String)"0", (int)lenMax).toCharArray();
            g.drawChars(c, 0, c.length, 3, i * fm.getHeight() + fm.getHeight());
        }
    }
}

