/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.brains2b.thex.BinaryDocument;

public class BinaryElement
implements Element {
    static final byte[] EMPTY = new byte[0];
    private AttributeSet m_attributes;
    private Document m_document;
    private BinaryElement m_parent;
    private int m_length;
    List<BinaryElement> m_elements;
    private int m_state;
    private byte[] m_bytes;

    public BinaryElement(Document document, AttributeSet attributes, int length) {
        this.m_document = document;
        this.m_attributes = attributes;
        this.m_length = length;
    }

    public BinaryElement(Document document, AttributeSet attributes, byte[] b) {
        this.m_document = document;
        this.m_attributes = attributes;
        this.m_length = b.length;
        this.m_bytes = b;
    }

    public AttributeSet getAttributes() {
        return this.m_attributes;
    }

    public Document getDocument() {
        return this.m_document;
    }

    public Element getElement(int index) {
        if (this.m_elements == null) {
            return null;
        }
        return this.m_elements.get(index);
    }

    public int getElementCount() {
        return this.m_elements == null ? 0 : this.m_elements.size();
    }

    public int getElementIndex(int offset) {
        if (this.m_elements == null) {
            return -1;
        }
        int curr = 0;
        for (int i = 0; i < this.m_elements.size(); ++i) {
            BinaryElement be = this.m_elements.get(i);
            curr += be.m_length;
            if (i == 0 && be.getEndOffset() == 0) {
                return i;
            }
            if (curr < offset) continue;
            return i;
        }
        return -1;
    }

    public int getEndOffset() {
        if (this.getElementCount() == 0) {
            return this.getStartOffset() + this.m_length;
        }
        int curr = 0;
        for (int i = 0; i < this.m_elements.size(); ++i) {
            BinaryElement be = this.m_elements.get(i);
            curr += be.m_length;
        }
        return curr;
    }

    public String getName() {
        return (String)this.m_attributes.getAttribute("$ename");
    }

    public Element getParentElement() {
        return this.m_parent;
    }

    void setParentElement(BinaryElement parent) {
        this.m_parent = parent;
    }

    public int getStartOffset() {
        BinaryElement be;
        if (this.getParentElement() == null) {
            return 0;
        }
        int curr = 0;
        for (int i = 0; i < this.getParentElement().getElementCount() && (be = (BinaryElement)this.getParentElement().getElement(i)) != this; ++i) {
            curr += be.m_length;
        }
        return curr;
    }

    public boolean isLeaf() {
        return this.getElementCount() == 0;
    }

    public void addElement(BinaryElement element) {
        if (this.m_elements == null) {
            this.m_elements = new ArrayList<BinaryElement>();
        }
        this.m_elements.add(element);
        element.setParentElement(this);
    }

    public void setLength(int length) {
        if (this.m_bytes == null || this.m_bytes.length == 0) {
            return;
        }
        this.m_length = length;
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int state) {
        this.m_state = state;
    }

    public byte[] getBytes() {
        if ((this.m_bytes == null || this.m_bytes.length == 0) && this.getState() == 0) {
            try {
                ((BinaryDocument)this.getDocument()).getIoKit().setBlockData(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_bytes == null) {
            return EMPTY;
        }
        return this.m_bytes;
    }

    public void setBytes(byte[] bytes) {
        this.m_bytes = bytes;
        if (bytes != null) {
            this.m_length = bytes.length;
        }
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.m_bytes = new byte[length];
        System.arraycopy(bytes, offset, this.m_bytes, 0, length);
        this.m_length = this.m_bytes.length;
    }
}

