/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.PseudoCaretComponent;
import org.brains2b.thex.ViewHex;
import org.brains2b.thex.gui.PseudoHighlighter;

public class BinaryEditor
extends JTextComponent
implements PseudoCaretComponent {
    private PseudoHighlighter m_painter;
    private PseudoHighlighter m_finder;
    private int m_mark;
    private int m_dot;

    public BinaryEditor(BinaryDocument d) {
        this.setDocument(d);
        this.m_painter = new PseudoHighlighter();
        this.updateUI();
    }

    public BinaryEditor(byte[] b) {
        this.setDocument(this.createDefaultModel());
        this.setBytes(b);
        this.m_painter = new PseudoHighlighter();
        this.updateUI();
    }

    public BinaryEditor() {
        this.setDocument(this.createDefaultModel());
        this.m_painter = new PseudoHighlighter();
        this.updateUI();
    }

    public void setBytes(byte[] b) {
        try {
            if (this.getDocument() instanceof BinaryDocument) {
                ((BinaryDocument)this.getDocument()).replaceBytes(0, b.length, b, null);
            }
        }
        catch (BadLocationException blex) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    public void replaceSelection(String content) {
        int p1;
        BinaryDocument doc = (BinaryDocument)this.getDocument();
        Caret c = this.getCaret();
        int p0 = Math.min(c.getDot(), c.getMark());
        if (p0 != (p1 = Math.max(c.getDot(), c.getMark()))) {
            try {
                doc.remove(p0, p1 - p0);
            }
            catch (BadLocationException blex) {}
        } else {
            Boolean replace = (Boolean)this.getClientProperty("replace");
            if (replace != null && replace.booleanValue() && doc.getLastString() != null) {
                try {
                    doc.remove(p0, 1);
                }
                catch (BadLocationException blex) {
                    // empty catch block
                }
            }
        }
        try {
            for (int i = 0; i < content.length(); ++i) {
                if (BinaryEditor.isHex(content.charAt(i))) continue;
                doc.setLastString(null);
                this.getToolkit().beep();
                return;
            }
            doc.insertString(p0, content, null);
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
    }

    private Document createDefaultModel() {
        BinaryDocument doc = new BinaryDocument();
        return doc;
    }

    public void updateUI() {
        if (this.getClientProperty("lastColumn") == null) {
            this.putClientProperty("lastColumn", 80);
        }
        this.setUI(new BasicTextUI(){

            public View create(Element elem) {
                return new ViewHex(elem);
            }

            protected String getPropertyPrefix() {
                return "EditorPane";
            }
        });
        this.invalidate();
    }

    public PseudoHighlighter getFindHighlighter() {
        return this.m_finder;
    }

    public PseudoHighlighter getPseudoHighlighter() {
        return this.m_painter;
    }

    public void setFindHighligter(PseudoHighlighter highlighter) {
        this.m_finder = highlighter;
        this.m_finder.install(this);
    }

    public void setPseudoHighlighter(PseudoHighlighter highlighter) {
        this.m_painter = highlighter;
        this.m_painter.install(this);
    }

    static final boolean isHex(char c) {
        return c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f' || c >= '0' && c <= '9';
    }
}

