/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import java.util.Properties;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;
import org.brains2b.log.Logger;
import org.brains2b.thex.BinaryElement;
import org.brains2b.thex.io.BinaryIOKit;
import org.brains2b.util.HexHelper;

public class BinaryDocument
implements Document {
    private BinaryElement m_root;
    private EventListenerList m_listenerList = new EventListenerList();
    private Properties m_properties = new Properties();
    private String m_lastString;
    private BinaryIOKit m_ioKit;
    private boolean m_lockUndo;

    public BinaryDocument() {
        this(new byte[0]);
    }

    public BinaryDocument(byte[] b) {
        this.m_root = new BinaryElement((Document)this, null, 0);
        this.m_root.addElement(new BinaryElement((Document)this, null, b));
    }

    public void addDocumentListener(DocumentListener listener) {
        this.m_listenerList.add(DocumentListener.class, listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.m_listenerList.add(UndoableEditListener.class, listener);
    }

    public Position createPosition(int offs) throws BadLocationException {
        return new BytePosition(offs);
    }

    public Element getDefaultRootElement() {
        return this.m_root;
    }

    public Position getEndPosition() {
        try {
            return this.createPosition(this.m_root.getEndOffset());
        }
        catch (BadLocationException blex) {
            return new BytePosition(-1);
        }
    }

    public int getLength() {
        return this.m_root.getEndOffset();
    }

    public Object getProperty(Object key) {
        return this.m_properties.get(key);
    }

    public Element[] getRootElements() {
        return new Element[]{this.m_root};
    }

    public Position getStartPosition() {
        return new BytePosition(0);
    }

    public String getText(int offset, int length) throws BadLocationException {
        return HexHelper.encode((byte[])this.getBytes(offset, length));
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        txt.array = this.getText(offset, length).toCharArray();
        txt.count = length;
        txt.offset = 0;
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        if (str.length() % 2 == 1 && this.m_lastString == null) {
            this.m_lastString = str;
            return;
        }
        if (this.m_lastString != null) {
            str = this.m_lastString + str;
        }
        this.m_lastString = null;
        this.insertBytes(offset, HexHelper.decode((String)str), a);
    }

    public byte[] getBytes(int offset, int length) throws BadLocationException {
        byte[] b = new byte[length];
        int idx = this.m_root.getElementIndex(offset);
        if (idx == -1) {
            return BinaryElement.EMPTY;
        }
        BinaryElement be = (BinaryElement)this.m_root.getElement(idx);
        while (be != null && (be.getStartOffset() <= offset || be.getStartOffset() <= length + offset)) {
            try {
                System.arraycopy(be.getBytes(), Math.max(0, offset - be.getStartOffset()), b, Math.max(0, be.getStartOffset() - offset), Math.min(be.getEndOffset() - Math.max(be.getStartOffset(), offset), length - Math.max(0, be.getStartOffset() - offset)));
            }
            catch (ArrayIndexOutOfBoundsException aiex) {
                Logger.print((Object)("> " + offset + ":" + length + " " + be.getBytes()));
            }
            if (++idx < this.m_root.getElementCount()) {
                be = (BinaryElement)this.m_root.getElement(idx);
                continue;
            }
            be = null;
        }
        return b;
    }

    public void insertBytes(int offset, byte[] b, AttributeSet a) throws BadLocationException {
        boolean empty;
        BinaryElement be;
        int idx = this.m_root.getElementIndex(offset);
        if (idx == -1) {
            be = new BinaryElement((Document)this, null, b);
            empty = true;
        } else {
            be = (BinaryElement)this.m_root.getElement(idx);
            empty = be.getBytes() == null || be.getEndOffset() - be.getStartOffset() == 0;
            byte[] data = new byte[be.getEndOffset() - be.getStartOffset() + b.length];
            System.arraycopy(be.getBytes(), 0, data, 0, offset - be.getStartOffset());
            System.arraycopy(b, 0, data, offset - be.getStartOffset(), b.length);
            System.arraycopy(be.getBytes(), offset - be.getStartOffset(), data, offset - be.getStartOffset() + b.length, be.getEndOffset() - offset);
            be.setLength(data.length);
            be.setBytes(data);
        }
        BinaryDocumentEvent de = new BinaryDocumentEvent(this, offset, b.length, DocumentEvent.EventType.INSERT);
        this.fireInsertUpdate(de);
        if (!empty && !this.m_lockUndo) {
            this.fireUndoableEdit(new UndoableEditEvent(this, de));
        }
    }

    public void putProperty(Object key, Object value) {
        this.m_properties.put(key, value);
    }

    public void remove(int offs, int len) throws BadLocationException {
        this.removeBytes(offs, len);
    }

    public void removeBytes(int offset, int len) throws BadLocationException {
        int idx = this.m_root.getElementIndex(offset);
        BinaryElement be = (BinaryElement)this.m_root.getElement(idx);
        if (idx == -1) {
            return;
        }
        byte[] undo = this.getBytes(offset, len);
        while (be != null && offset >= be.getStartOffset() && offset < be.getEndOffset()) {
            if (offset <= be.getStartOffset() && offset + len >= be.getEndOffset()) {
                if (idx == 0) {
                    be.setBytes(new byte[0]);
                    be.setLength(0);
                } else {
                    this.m_root.m_elements.remove(be);
                    --idx;
                }
            } else {
                int boffs = offset - be.getStartOffset();
                int blen = Math.min(len, be.getEndOffset() - boffs);
                byte[] b = new byte[be.getEndOffset() - be.getStartOffset() - blen];
                System.arraycopy(be.getBytes(), 0, b, 0, boffs);
                System.arraycopy(be.getBytes(), boffs + blen, b, boffs, be.getEndOffset() - be.getStartOffset() - boffs - blen);
                be.setLength(b.length);
                be.setBytes(b);
            }
            if (this.m_root.getElementCount() <= idx + 1) {
                be = null;
                continue;
            }
            be = (BinaryElement)this.m_root.getElement(++idx);
        }
        BinaryDocumentEvent de = new BinaryDocumentEvent(this, offset, len, DocumentEvent.EventType.REMOVE);
        this.fireRemoveUpdate(de);
        if (!this.m_lockUndo && offset >= 0 && len > 0) {
            de.setSnippet(undo);
            this.fireUndoableEdit(new UndoableEditEvent(this, de));
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.m_listenerList.remove(DocumentListener.class, listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.m_listenerList.remove(UndoableEditListener.class, listener);
    }

    public void replaceBytes(int offset, int length, byte[] b, AttributeSet atts) throws BadLocationException {
        if (length == 0 && (b == null || b.length == 0)) {
            return;
        }
        if (length > 0) {
            this.remove(offset, length);
        }
        if (b != null && b.length > 0) {
            this.insertBytes(offset, b, null);
        }
    }

    public void render(Runnable r) {
        r.run();
    }

    protected void fireChangedUpdate(DocumentEvent de) {
        DocumentListener[] l = (DocumentListener[])this.m_listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].changedUpdate(de);
        }
    }

    protected void fireInsertUpdate(DocumentEvent de) {
        DocumentListener[] l = (DocumentListener[])this.m_listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].insertUpdate(de);
        }
    }

    protected void fireRemoveUpdate(DocumentEvent de) {
        DocumentListener[] l = (DocumentListener[])this.m_listenerList.getListeners(DocumentListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].removeUpdate(de);
        }
    }

    protected void fireUndoableEdit(UndoableEditEvent ue) {
        UndoableEditListener[] l = (UndoableEditListener[])this.m_listenerList.getListeners(UndoableEditListener.class);
        for (int i = 0; i < l.length; ++i) {
            l[i].undoableEditHappened(ue);
        }
    }

    public String getLastString() {
        return this.m_lastString;
    }

    BinaryIOKit getIoKit() {
        if (this.m_ioKit == null) {
            this.m_ioKit = new BinaryIOKit();
        }
        return this.m_ioKit;
    }

    public void setLastString(String lastString) {
        this.m_lastString = lastString;
    }

    public void documentUpdated() {
        BinaryDocumentEvent ev = new BinaryDocumentEvent(this, 0, this.getLength(), DocumentEvent.EventType.INSERT);
        this.fireInsertUpdate(ev);
    }

    class BytePosition
    implements Position {
        private int m_offset;

        public BytePosition(int offset) {
            this.m_offset = offset;
        }

        public int getOffset() {
            return this.m_offset;
        }
    }

    class BinaryDocumentEvent
    extends AbstractUndoableEdit
    implements DocumentEvent {
        private BinaryDocument m_document;
        private int m_length;
        private int m_offset;
        private DocumentEvent.EventType m_type;
        private byte[] m_snip;

        public BinaryDocumentEvent(BinaryDocument document, int offset, int length, DocumentEvent.EventType type) {
            this.m_document = document;
            this.m_offset = offset;
            this.m_length = length;
            this.m_type = type;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            BinaryDocument.this.m_lockUndo = true;
            try {
                if (DocumentEvent.EventType.INSERT == this.m_type) {
                    this.m_snip = this.m_document.getBytes(this.m_offset, this.m_length);
                    this.m_document.removeBytes(this.m_offset, this.m_length);
                } else if (DocumentEvent.EventType.REMOVE == this.m_type) {
                    this.m_document.insertBytes(this.m_offset, this.m_snip, null);
                } else if (DocumentEvent.EventType.CHANGE == this.m_type) {
                    byte[] b = this.m_document.getBytes(this.m_offset, this.m_length);
                    this.m_document.replaceBytes(this.m_offset, this.m_length, this.m_snip, null);
                    this.m_snip = b;
                }
            }
            catch (BadLocationException blex) {
                throw new CannotUndoException();
            }
            BinaryDocument.this.m_lockUndo = false;
        }

        public void redo() throws CannotUndoException {
            super.redo();
            BinaryDocument.this.m_lockUndo = true;
            try {
                if (DocumentEvent.EventType.INSERT == this.m_type) {
                    this.m_document.insertBytes(this.m_offset, this.m_snip, null);
                } else if (DocumentEvent.EventType.REMOVE == this.m_type) {
                    this.m_snip = this.m_document.getBytes(this.m_offset, this.m_length);
                    this.m_document.removeBytes(this.m_offset, this.m_length);
                } else if (DocumentEvent.EventType.CHANGE == this.m_type) {
                    byte[] b = this.m_document.getBytes(this.m_offset, this.m_length);
                    this.m_document.replaceBytes(this.m_offset, this.m_length, this.m_snip, null);
                    this.m_snip = b;
                }
            }
            catch (BadLocationException blex) {
                throw new CannotUndoException();
            }
            BinaryDocument.this.m_lockUndo = false;
        }

        public DocumentEvent.ElementChange getChange(Element elem) {
            return null;
        }

        public Document getDocument() {
            return this.m_document;
        }

        public int getLength() {
            return this.m_length;
        }

        public int getOffset() {
            return this.m_offset;
        }

        public DocumentEvent.EventType getType() {
            return this.m_type;
        }

        public void setSnippet(byte[] b) {
            this.m_snip = b;
        }
    }
}

