/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.thex;

import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.brains2b.thex.BinaryDocument;
import org.brains2b.thex.PseudoCaretComponent;
import org.brains2b.thex.ViewAscii;
import org.brains2b.thex.gui.PseudoHighlighter;

public class AsciiEditor
extends JTextComponent
implements PseudoCaretComponent {
    private PseudoHighlighter m_painter;
    private PseudoHighlighter m_finder;

    public AsciiEditor(BinaryDocument d) {
        this.setDocument(d);
    }

    public AsciiEditor(byte[] b) {
        this.setDocument(this.createDefaultModel());
        this.setBytes(b);
    }

    public AsciiEditor() {
        this.setDocument(this.createDefaultModel());
    }

    public void setBytes(byte[] b) {
        try {
            if (this.getDocument() instanceof BinaryDocument) {
                ((BinaryDocument)this.getDocument()).replaceBytes(0, b.length, b, null);
            }
        }
        catch (BadLocationException blex) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    private Document createDefaultModel() {
        BinaryDocument doc = new BinaryDocument();
        return doc;
    }

    public void setText(String t) {
        this.setBytes(t.getBytes());
    }

    public String getText() {
        try {
            return this.getText(0, this.getDocument().getLength() / 2);
        }
        catch (BadLocationException blex) {
            return null;
        }
    }

    public String getText(int offs, int len) throws BadLocationException {
        BinaryDocument doc = (BinaryDocument)this.getDocument();
        byte[] b = doc.getBytes(offs, len);
        return new String(b);
    }

    public void replaceSelection(String content) {
        int p1;
        BinaryDocument doc = (BinaryDocument)this.getDocument();
        Caret c = this.getCaret();
        int p0 = Math.min(c.getDot(), c.getMark());
        if (p0 != (p1 = Math.max(c.getDot(), c.getMark()))) {
            try {
                doc.removeBytes(p0, p1 - p0);
            }
            catch (BadLocationException blex) {}
        } else {
            Boolean replace = (Boolean)this.getClientProperty("replace");
            if (replace != null && replace.booleanValue()) {
                try {
                    doc.removeBytes(p0, 1);
                }
                catch (BadLocationException blex) {
                    // empty catch block
                }
            }
        }
        try {
            doc.insertBytes(p0, content.getBytes(), null);
        }
        catch (BadLocationException blex) {
            // empty catch block
        }
    }

    public void updateUI() {
        if (this.getClientProperty("lastColumn") == null) {
            this.putClientProperty("lastColumn", 80);
        }
        this.setUI(new BasicTextUI(){

            public View create(Element elem) {
                return new ViewAscii(elem);
            }

            protected String getPropertyPrefix() {
                return "EditorPane";
            }
        });
        this.invalidate();
    }

    public PseudoHighlighter getFindHighlighter() {
        return this.m_finder;
    }

    public PseudoHighlighter getPseudoHighlighter() {
        return this.m_painter;
    }

    public void setFindHighligter(PseudoHighlighter highlighter) {
        this.m_finder = highlighter;
        this.m_finder.install(this);
    }

    public void setPseudoHighlighter(PseudoHighlighter highlighter) {
        this.m_painter = highlighter;
        this.m_painter.install(this);
    }
}

