/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.brains2b.log.Logger;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.types.Stream;

public class TypesInfo {
    public static final TypesInfo DEFAULT = new TypesInfo();
    public static final int SMALLEST = 22;
    public static final int OPTIMIZE = 10;
    public static final int LARGE = 9;
    private int m_dataModel = 10;
    private List m_types;
    private String m_dbUrl;

    TypesInfo() {
    }

    public TypesInfo(Connection con) {
        try {
            this.setTargetTypes(con);
            this.m_dbUrl = con.getMetaData().getURL();
        }
        catch (SQLException sqex) {
            Logger.println((String)sqex.getMessage(), (int)16);
        }
    }

    public int getDataType(Class c) {
        if (c == Boolean.TYPE) {
            return -7;
        }
        if (c == Short.TYPE) {
            return 5;
        }
        if (c == Integer.TYPE) {
            return 4;
        }
        if (c == Long.TYPE || c == Float.TYPE || c == Double.TYPE) {
            return 3;
        }
        if (c == String.class) {
            return 12;
        }
        if (c == Date.class) {
            return 91;
        }
        if (c == Timestamp.class) {
            return 93;
        }
        return 1111;
    }

    private String getDefaultDatatype(int dataType) {
        String type = null;
        switch (dataType) {
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                type = "NUMBER";
                break;
            }
            case 1: 
            case 12: {
                type = "VARCHAR2";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                type = "DATE";
                break;
            }
            case 1111: {
                type = "BLOB";
                break;
            }
            default: {
                type = "/* value: " + dataType + " cannot be determinend */";
            }
        }
        return type;
    }

    public String getJavaTypeName(int dataType, int columnsize, int decimaldigits) {
        String type = "";
        switch (dataType) {
            case -7: {
                type = "boolean";
                break;
            }
            case -6: {
                type = "short";
                break;
            }
            case 4: {
                type = "int";
                break;
            }
            case 5: {
                type = "short";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                if (decimaldigits == 0) {
                    if (columnsize < this.m_dataModel) {
                        type = "int";
                        break;
                    }
                    type = "long";
                    break;
                }
                if (columnsize < 22 && decimaldigits < this.m_dataModel) {
                    type = "double";
                    break;
                }
                type = "float";
                break;
            }
            case 1: {
                type = "String";
                break;
            }
            case 12: {
                type = "String";
                break;
            }
            case 91: {
                type = "Date";
                break;
            }
            case 92: 
            case 93: {
                type = "Timestamp";
                break;
            }
            case 1111: {
                type = "Object";
                break;
            }
            case -4: 
            case -1: {
                type = "Stream";
                break;
            }
            case 2005: {
                type = "Clob";
                break;
            }
            case 2004: {
                type = "Blob";
                break;
            }
            default: {
                type = "/* value: " + dataType + " cannot be determinend */";
            }
        }
        return type;
    }

    public boolean isPrimitive(int dataType) {
        return this.getJavaType(dataType, 0, 0).isPrimitive();
    }

    public Class getJavaType(int dataType, int columnsize, int decimaldigits) {
        Class<Object> type = null;
        switch (dataType) {
            case -7: {
                type = Boolean.TYPE;
                break;
            }
            case 4: {
                type = Integer.TYPE;
                break;
            }
            case -6: 
            case 5: {
                type = Short.TYPE;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                if (decimaldigits == 0) {
                    if (columnsize < this.m_dataModel) {
                        type = Integer.TYPE;
                        break;
                    }
                    type = Long.TYPE;
                    break;
                }
                if (columnsize < 22 && decimaldigits < this.m_dataModel) {
                    type = Double.TYPE;
                    break;
                }
                type = Float.TYPE;
                break;
            }
            case 1: 
            case 12: {
                type = String.class;
                break;
            }
            case 91: {
                type = Date.class;
                break;
            }
            case 92: 
            case 93: {
                type = Timestamp.class;
                break;
            }
            case 1111: {
                type = Object.class;
                break;
            }
            case -1: {
                type = Stream.class;
                break;
            }
            case -4: {
                type = Stream.class;
                break;
            }
            case 2005: {
                type = Clob.class;
                break;
            }
            case 2004: {
                type = Blob.class;
            }
            default: {
                type = String.class;
            }
        }
        return type;
    }

    public String getLimitRows(int count) {
        if (this.m_dbUrl.indexOf("oracle") != -1) {
            return " WHERE ROWNUM < " + count;
        }
        return " LIMIT " + count;
    }

    public String getSQLType(int dataType, int columnSize, int decimaldigits) {
        String s = null;
        if (this.isTargetTypesSet()) {
            Iterator it = this.m_types.iterator();
            while (it.hasNext()) {
                SQLRecord record = (SQLRecord)it.next();
                if (record.getIntValue("DATA_TYPE") != dataType || record.getIntValue("PRECISION") < columnSize || record.getIntValue("MAX_SCALE") < decimaldigits) continue;
                s = record.getString("TYPE_NAME");
                break;
            }
        }
        if (s == null) {
            s = this.getDefaultDatatype(dataType);
        }
        return s;
    }

    public int getDataType(String typeName, int columnSize, int decimaldigits) {
        int dataType = 0;
        if (this.isTargetTypesSet()) {
            Iterator it = this.m_types.iterator();
            while (it.hasNext()) {
                SQLRecord record = (SQLRecord)it.next();
                if (!record.getString("TYPE_NAME").equals(typeName) || record.getIntValue("PRECISION") < columnSize || record.getIntValue("MAX_SCALE") < decimaldigits) continue;
                dataType = record.getIntValue("DATA_TYPE");
                break;
            }
        }
        return dataType;
    }

    public Collection getTypeNames() {
        if (!this.isTargetTypesSet()) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator it = this.m_types.iterator();
        while (it.hasNext()) {
            SQLRecord record = (SQLRecord)it.next();
            if (list.contains(record.getValue("TYPE_NAME"))) continue;
            list.add(record.getValue("TYPE_NAME"));
        }
        Collections.sort(list);
        return list;
    }

    public List getTypes() {
        return this.m_types;
    }

    private final boolean isTargetTypesSet() {
        return this.m_types != null;
    }

    public void setDataModel(int dataModel) {
        this.m_dataModel = dataModel;
    }

    private final void setTargetTypes(Connection con) throws SQLException {
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getTypeInfo();
        this.m_types = new ArrayList();
        while (rs.next()) {
            SQLRecord record = SQLRecord.createRecord(rs);
            if (meta.getDriverName().indexOf("Oracle") != -1 && rs.getInt("DATA_TYPE") == 93) {
                record.setValue("TYPE_NAME", (Object)"DATE");
            }
            this.m_types.add(record);
        }
        rs.close();
    }
}

