/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ConstraintModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class TableModel
implements SQLMetaModel {
    private SQLRecord m_record;
    private List m_columns;
    private List m_indices;
    private ConstraintModel m_primaryKey;

    protected TableModel() {
    }

    public TableModel(SQLRecord record) {
        this.m_record = record;
    }

    public String getName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public String getCatalog() {
        return this.m_record.getString("TABLE_CAT");
    }

    public String getSchema() {
        return this.m_record.getString("TABLE_SCHEM");
    }

    public String getRemarks() {
        return this.m_record.getString("REMARKS");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return this.m_record.getString("TABLE_TYPE");
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setColumns(List columns) {
        this.m_columns = columns;
    }

    public List getIndices() {
        return this.m_indices;
    }

    protected void setIndices(List indices) {
        this.m_indices = indices;
    }

    protected void setPrimaryKey(ConstraintModel primaryKey) {
        if (primaryKey != null && primaryKey.getType() != "PRIMARY KEY") {
            throw new IllegalArgumentException("You can only set a primary key to the table");
        }
        this.m_primaryKey = primaryKey;
    }

    protected void setRecord(SQLRecord record) {
        this.m_record = record;
    }

    public ConstraintModel getPrimaryKey() {
        return this.m_primaryKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableModel)) {
            return false;
        }
        TableModel tm = (TableModel)obj;
        boolean b = this.m_record.equals(tm.getRecord());
        if (!b || this.m_columns == null || this.m_columns.isEmpty()) {
            return b;
        }
        List cols = tm.getColumns();
        if (cols == null || cols.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            b = this.m_columns.get(i).equals(cols.get(i));
            if (b) continue;
            return b;
        }
        boolean bl = b = this.m_primaryKey == null ? b : this.m_primaryKey.equals(tm.getPrimaryKey());
        if (!b || this.m_indices == null || this.m_indices.isEmpty()) {
            return b;
        }
        List indices = tm.getColumns();
        if (indices == null || indices.size() != this.m_indices.size()) {
            return false;
        }
        for (int i = 0; i < this.m_indices.size(); ++i) {
            b = this.m_indices.get(i).equals(indices.get(i));
            if (b) continue;
            return b;
        }
        return true;
    }
}

