/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import org.brains2b.util.StringHelper;

public class SelectDescriptor {
    private String[] m_sqlKeys = new String[7];

    public SelectDescriptor(String sql) {
        this.parse(sql);
    }

    public String toString() {
        return this.m_sqlKeys[0];
    }

    public String getColumns() {
        return this.m_sqlKeys[1];
    }

    public String getFrom() {
        return this.m_sqlKeys[2];
    }

    public String getWhere() {
        return this.m_sqlKeys[3];
    }

    public String getGroupBy() {
        return this.m_sqlKeys[4];
    }

    public String getHaving() {
        return this.m_sqlKeys[5];
    }

    public String getOrderBy() {
        return this.m_sqlKeys[6];
    }

    private void parse(String sql) {
        if (sql == null) {
            return;
        }
        String usql = sql.toUpperCase();
        int pos = usql.length();
        pos = this.parsePart(usql, sql, "ORDER BY", 6, pos);
        pos = this.parsePart(usql, sql, "HAVING", 5, pos);
        pos = this.parsePart(usql, sql, "GROUP BY", 4, pos);
        pos = this.parsePart(usql, sql, "WHERE", 3, pos);
        pos = this.parsePart(usql, sql, "FROM", 2, pos);
        pos = this.parsePart(usql, sql, "SELECT", 1, pos);
        this.m_sqlKeys[0] = sql;
    }

    private int parsePart(String usql, String sql, String key, int idx, int pos) {
        int c = -1;
        c = usql.indexOf(key);
        int bs = usql.indexOf(40);
        int be = StringHelper.matchBracket((int)bs, (String)usql);
        if (be != -1 && bs < c && be > c) {
            c = usql.indexOf(key, be);
        }
        if (c >= 0 && c < pos) {
            this.m_sqlKeys[idx] = sql.substring(c, pos);
            pos = c;
        }
        return pos;
    }
}

