/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.brains2b.log.Logger;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.ConstraintModel;
import org.brains2b.sql.meta.IndexModel;
import org.brains2b.sql.meta.ParameterModel;
import org.brains2b.sql.meta.ProcedureModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.meta.TypesInfo;

public class SQLMetaData {
    private DatabaseMetaData m_dbMeta;
    private Connection m_con;
    private String[] m_types;
    private PreparedStatement m_prep;
    private TypesInfo m_sqlTypes;

    public SQLMetaData() {
    }

    public SQLMetaData(Connection connection) {
        this.m_con = connection;
        this.m_dbMeta = null;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.m_dbMeta == null) {
            this.m_dbMeta = this.m_con.getMetaData();
        }
        return this.m_dbMeta;
    }

    public List getCatalogs() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getCatalogs();
        while (rs.next()) {
            list.add(rs.getString("TABLE_CAT"));
        }
        rs.close();
        return list;
    }

    public List getSchemas() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getSchemas();
        while (rs.next()) {
            list.add(rs.getString("TABLE_SCHEM"));
        }
        rs.close();
        return list;
    }

    public List getTableTypes() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getTableTypes();
        while (rs.next()) {
            list.add(rs.getString("TABLE_TYPE"));
        }
        list.remove("SYNONYM");
        rs.close();
        return list;
    }

    private String[] getTypes() throws SQLException {
        if (this.m_types == null) {
            List list = this.getTableTypes();
            this.m_types = new String[list.size()];
            list.toArray(this.m_types);
        }
        return this.m_types;
    }

    public List getTablesWithColumns(String catalog, String schemaPattern, String tablePattern) throws SQLException {
        List list = this.getTables(catalog, schemaPattern, tablePattern);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TableModel model = (TableModel)it.next();
            model.setColumns(this.getColumns(model.getCatalog(), model.getSchema(), model.getName(), null));
        }
        return list;
    }

    public List getTables(String catalog, String schemaPattern, String tablePattern) throws SQLException {
        return this.getTables(catalog, schemaPattern, tablePattern, null);
    }

    public List getTables(String catalog, String schemaPattern, String tablePattern, String type) throws SQLException {
        String[] types = null;
        types = type == null ? this.getTypes() : new String[]{type};
        ArrayList<TableModel> list = new ArrayList<TableModel>();
        ResultSet rs = this.getMetaData().getTables(catalog, schemaPattern, tablePattern, types);
        while (rs.next()) {
            TableModel tm = new TableModel(SQLRecord.createRecord(rs));
            list.add(tm);
        }
        rs.close();
        return list;
    }

    public void setColumns(TableModel table) throws SQLException {
        List columns = this.getColumns(table.getCatalog(), table.getSchema(), table.getName(), null);
        table.setColumns(columns);
    }

    public List getColumns(String catalog, String schemaPattern, String tablePattern, String columnPattern) throws SQLException {
        ArrayList<ColumnModel> list = new ArrayList<ColumnModel>();
        ResultSet rs = this.getMetaData().getColumns(catalog, schemaPattern, tablePattern, columnPattern);
        while (rs.next()) {
            ColumnModel column = new ColumnModel(SQLRecord.createRecord(rs));
            if (column.getDataType() == 91 && this.isOracleDriver()) {
                column.getRecord().setValue("DATA_TYPE", (Object)new Integer(93));
            }
            list.add(column);
        }
        rs.close();
        return list;
    }

    public void setPrimaryKey(TableModel tm) throws SQLException {
        this.setPrimaryKey(tm, false);
    }

    public void setPrimaryKey(TableModel tm, boolean forceRowid) throws SQLException {
        try {
            if (!forceRowid) {
                List constraints = this.getConstraints(tm.getCatalog(), tm.getSchema(), tm.getName(), "PRIMARY KEY");
                if (constraints.isEmpty() && !tm.getType().equals("VIEW")) {
                    this.setPseudoKeys(tm);
                    if (tm.getPrimaryKey() == null) {
                        Logger.println((String)("TABLE " + tm.getName() + " Primary Keys are defined as pseudo"), (int)16);
                    }
                } else if (!constraints.isEmpty()) {
                    tm.setPrimaryKey((ConstraintModel)constraints.get(0));
                }
            }
            if (forceRowid || tm.getPrimaryKey() == null && !tm.getType().equals("VIEW")) {
                SQLRecord record = new SQLRecord(9);
                record.setColumn(0, "TYPE", String.class, "COLUMN");
                record.setColumn(1, "ORDINAL_POSITION", Integer.class, new Integer(1));
                record.setColumn(2, "COLUMN_NAME", String.class, "ROWID");
                record.setColumn(3, "TABLE_NAME", String.class, tm.getName());
                record.setColumn(4, "DATA_TYPE", Integer.class, new Integer(1111));
                record.setColumn(5, "TYPE_NAME", String.class, "ROWID");
                record.setColumn(6, "TABLE_CAT", String.class, tm.getCatalog());
                ColumnModel cm = new ColumnModel(record);
                tm.getColumns().add(cm);
                record = new SQLRecord(2);
                record.setColumn(0, "NAME", String.class, "ROWID");
                record.setColumn(1, "TABLE_NAME", String.class, tm.getName());
                ConstraintModel model = new ConstraintModel("PRIMARY KEY", record);
                SQLRecord rec = (SQLRecord)cm.getRecord().clone();
                rec.setValue("ORDINAL_POSITION", (Object)new Integer(1));
                model.addColumn(new ColumnModel(rec));
                tm.setPrimaryKey(model);
                Logger.println((String)("TABLE " + tm.getName() + " has NO primary key, ROWID used"), (int)16);
            }
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 0) {
                Logger.println((String)"JDBC Driver does not support primary keys", (int)4);
            }
            throw se;
        }
    }

    private void setPseudoKeys(TableModel tm) throws SQLException {
        List indexes = this.getIndices(tm.getCatalog(), tm.getSchema(), tm.getName(), true);
        if (indexes != null) {
            Iterator it = indexes.iterator();
            IndexModel best = null;
            while (it.hasNext()) {
                IndexModel idx = (IndexModel)it.next();
                if (!idx.isUnique() || best != null && best.getColumns().size() <= idx.getColumns().size()) continue;
                best = idx;
            }
            if (best == null) {
                return;
            }
            SQLRecord record = new SQLRecord(2);
            record.setColumn(0, "NAME", String.class, "ROWID");
            record.setColumn(1, "TABLE_NAME", String.class, tm.getName());
            ConstraintModel model = new ConstraintModel("PRIMARY KEY", record);
            for (int i = 0; i < tm.getColumns().size(); ++i) {
                ColumnModel cm = (ColumnModel)tm.getColumns().get(i);
                for (int j = 0; j < best.getColumns().size(); ++j) {
                    if (!((ColumnModel)best.getColumns().get(j)).getName().equals(cm.getName())) continue;
                    model.addColumn(cm);
                }
            }
            tm.setPrimaryKey(model);
        }
    }

    public void setIndices(TableModel table, boolean onlyUnique) throws SQLException {
        List indices = this.getIndices(table.getCatalog(), table.getSchema(), table.getName(), onlyUnique);
        table.setIndices(indices);
    }

    public List getIndices(String catalog, String schemaPattern, String tablePattern, boolean onlyUnique) throws SQLException {
        HashMap<String, IndexModel> indices = new HashMap<String, IndexModel>();
        ResultSet rs = null;
        rs = this.isOracleDriver() ? this.getOracleIndexes(schemaPattern, tablePattern, onlyUnique) : this.getMetaData().getIndexInfo(catalog, schemaPattern, tablePattern, onlyUnique, true);
        while (rs.next()) {
            SQLRecord record = SQLRecord.createRecord(rs);
            IndexModel index = new IndexModel(this.createSubSet(record, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME"}));
            ColumnModel column = new ColumnModel(this.createSubSet(record, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC"}));
            String name = index.getName();
            if (name == null) continue;
            IndexModel idx = (IndexModel)indices.get(name);
            if (idx == null) {
                idx = new IndexModel(record);
                indices.put(name, idx);
            }
            idx.setColumn(column.getSequence(), column);
        }
        rs.close();
        if (this.isOracleDriver() && this.m_prep != null) {
            this.m_prep.close();
        }
        return new ArrayList(indices.values());
    }

    public List getProcedures(String catalog, String schema, String pattern) throws SQLException {
        return this.getProcedures(catalog, schema, pattern, true);
    }

    public List getProcedures(String catalog, String schema, String pattern, boolean includeParms) throws SQLException {
        ArrayList<ProcedureModel> result = new ArrayList<ProcedureModel>();
        ResultSet rs = this.getMetaData().getProcedures(catalog, schema, pattern);
        while (rs.next()) {
            ProcedureModel proc = new ProcedureModel(SQLRecord.createRecord(rs));
            if (includeParms) {
                this.setParameters(proc);
            }
            result.add(proc);
        }
        rs.close();
        return result;
    }

    public void setParameters(ProcedureModel proc) throws SQLException {
        List param = this.getParameters(proc.getCatalog(), proc.getSchema(), proc.getName());
        if (proc.getType() == "FUNCTION") {
            proc.setReturnValue((ParameterModel)param.get(0));
            param.remove(0);
        }
        proc.setParameters(param);
    }

    public List getParameters(String catalog, String schema, String procName) throws SQLException {
        ArrayList<ParameterModel> result = new ArrayList<ParameterModel>();
        ResultSet rs = this.getMetaData().getProcedureColumns(catalog == null ? "" : catalog, schema, procName, null);
        while (rs.next()) {
            ParameterModel param = new ParameterModel(SQLRecord.createRecord(rs));
            result.add(param);
        }
        rs.close();
        return result;
    }

    public Connection getConnection() {
        return this.m_con;
    }

    public void setConnection(Connection con) {
        this.m_con = con;
        this.m_dbMeta = null;
    }

    public List getConstraints(String catalog, String schema, String table, String type) throws SQLException {
        ColumnModel column;
        String name;
        ResultSet rs;
        String lastName = null;
        ArrayList<ConstraintModel> list = new ArrayList<ConstraintModel>();
        ConstraintModel model = null;
        SQLRecord record = null;
        if (type == null || type == "PRIMARY KEY") {
            rs = this.getMetaData().getPrimaryKeys(catalog, schema, table);
            while (rs.next()) {
                record = SQLRecord.createRecord(rs);
                name = rs.getString("PK_NAME");
                if (name == null && lastName == null || !name.equals(lastName)) {
                    model = new ConstraintModel("PRIMARY KEY", this.createSubSet(record, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "PK_NAME"}, "PK"));
                    list.add(model);
                }
                column = new ColumnModel(this.createSubSet(record, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ"}));
                this.renameColumn(column.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                model.addColumn(column);
                lastName = name;
            }
        }
        model = null;
        record = null;
        lastName = null;
        if (type == null || type == "FOREIGN KEY") {
            rs = this.getMetaData().getImportedKeys(catalog, schema, table);
            while (rs.next()) {
                record = SQLRecord.createRecord(rs);
                name = rs.getString("FK_NAME");
                if (name == null && lastName == null || !name.equals(lastName)) {
                    model = new ConstraintModel("FOREIGN KEY", this.createSubSet(record, new String[]{"FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FK_NAME", "UPDATE_RULE", "DELETE_RULE", "DEFERRABILITY"}, "FK"));
                    list.add(model);
                }
                column = new ColumnModel(this.createSubSet(record, new String[]{"FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ"}, "FK"));
                this.renameColumn(column.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                model.addColumn(column);
                column = new ColumnModel(this.createSubSet(record, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "KEY_SEQ"}, "PK"));
                this.renameColumn(column.getRecord(), "KEY_SEQ", "ORDINAL_POSITION");
                model.addColumn(column);
                lastName = name;
            }
        }
        return list;
    }

    private SQLRecord createSubSet(SQLRecord record, String[] columns) throws SQLException {
        return this.createSubSet(record, columns, null);
    }

    private SQLRecord createSubSet(SQLRecord record, String[] columns, String prefix) throws SQLException {
        SQLRecord sub = new SQLRecord(columns.length);
        for (int i = 0; i < columns.length; ++i) {
            int idx = record.getIndex(columns[i]);
            if (prefix != null && columns[i].startsWith(prefix)) {
                int start = prefix.length();
                if (columns[i].charAt(start) == '_') {
                    ++start;
                }
                columns[i] = columns[i].substring(start);
            }
            if (idx == -1) continue;
            sub.setColumn(i, columns[i], record.getColumnType(idx), record.getValue(idx));
        }
        return sub;
    }

    private void renameColumn(SQLRecord record, String oldName, String newName) {
        int idx = record.getIndex(oldName);
        if (idx != -1) {
            record.setColumn(idx, newName);
        }
    }

    private boolean isOracleDriver() throws SQLException {
        return "Oracle".equals(this.getMetaData().getDatabaseProductName());
    }

    private ResultSet getOracleIndexes(String schemaPattern, String tablePattern, boolean onlyUnique) throws SQLException {
        this.m_prep = this.getMetaData().getConnection().prepareStatement("SELECT NULL TABLE_CAT, I.TABLE_OWNER TABLE_SCHEM,I.TABLE_NAME, I.INDEX_NAME, INDEX_TYPE INDEX_QUALIFIER,COLUMN_NAME, DECODE(UNIQUENESS,'UNIQUE',0,1) NON_UNIQUE, COLUMN_POSITION ORDINAL_POSITION, DESCEND ASC_OR_DESC FROM ALL_INDEXES I, ALL_IND_COLUMNS C  WHERE I.TABLE_OWNER LIKE ? AND I.TABLE_NAME LIKE ? AND I.INDEX_NAME = C.INDEX_NAME AND I.OWNER = C.INDEX_OWNER AND  ((UNIQUENESS='UNIQUE' AND 1=?) OR (0=?)) ORDER BY TABLE_CAT, TABLE_SCHEM, I.TABLE_NAME,ORDINAL_POSITION");
        this.m_prep.setString(1, schemaPattern == null ? "%" : schemaPattern);
        this.m_prep.setString(2, tablePattern);
        this.m_prep.setInt(3, onlyUnique ? 1 : 0);
        this.m_prep.setInt(4, onlyUnique ? 1 : 0);
        ResultSet rs = this.m_prep.executeQuery();
        return rs;
    }

    public TypesInfo getTypeInfo() {
        if (this.m_sqlTypes == null) {
            try {
                this.m_sqlTypes = new TypesInfo(this.m_con);
                this.getMetaData();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.m_sqlTypes;
    }
}

