/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.util.Iterator;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ParameterModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class ProcedureModel
implements SQLMetaModel {
    public static final String PROCEDURE = "PROCEDURE";
    public static final String FUNCTION = "FUNCTION";
    public static final String PACKAGE = "PACKAGE";
    public static final String PACKAGE_BODY = "PACKAGE BODY";
    private SQLRecord m_record;
    private List parameters;
    private ParameterModel returnValue;

    protected ProcedureModel() {
    }

    public ProcedureModel(SQLRecord record) {
        this.m_record = record;
        String type = PROCEDURE;
        if (this.m_record.getIntValue("PROCEDURE_TYPE") == 2) {
            type = FUNCTION;
        }
        this.m_record.setColumn(this.m_record.getColumnCount(), "TYPE", String.class, type);
    }

    public String getName() {
        return this.m_record.getString("PROCEDURE_NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return this.m_record.getString("TYPE");
    }

    public List getParameters() {
        return this.parameters;
    }

    protected void setParameters(List list) {
        this.parameters = list;
    }

    public ParameterModel getReturnValue() {
        return this.returnValue;
    }

    protected void setReturnValue(ParameterModel model) {
        this.returnValue = model;
    }

    public String getCatalog() {
        return this.m_record.getString("PROCEDURE_CAT");
    }

    public String getSchema() {
        return this.m_record.getString("PROCEDURE_SCHEM");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterModel)) {
            return false;
        }
        ProcedureModel tm = (ProcedureModel)obj;
        boolean b = this.m_record.equals(tm.getRecord());
        if (!b || this.parameters == null || this.parameters.isEmpty()) {
            return b;
        }
        List cols = tm.getParameters();
        if (cols == null || cols.size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            b = this.parameters.get(i).equals(cols.get(i));
            if (b) continue;
            return b;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getType()).append(" ");
        sb.append(this.getSchema()).append(".").append(this.getCatalog()).append(".");
        sb.append(this.getName()).append("( ");
        int cnt = 0;
        Iterator it = this.getParameters().iterator();
        while (it.hasNext()) {
            ParameterModel pm = (ParameterModel)it.next();
            if (cnt > 0) {
                sb.append(", ");
            }
            sb.append(pm.toString());
        }
        sb.append(" )");
        if (this.getReturnValue() != null) {
            sb.append(" ").append(this.getReturnValue().getType());
        }
        return sb.toString();
    }
}

