/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class IndexModel
implements SQLMetaModel {
    private SQLRecord m_record;
    private List m_columns;

    protected IndexModel() {
    }

    public IndexModel(SQLRecord record) {
        this.m_record = record;
    }

    public String getName() {
        return this.m_record.getString("INDEX_NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return "INDEX";
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setColumns(List columns) {
        this.m_columns = columns;
    }

    public String getTableName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public boolean isUnique() {
        if (this.m_record.getValue("NON_UNIQUE") instanceof Integer || this.m_record.getValue("NON_UNIQUE") instanceof BigDecimal || this.m_record.getValue("NON_UNIQUE") instanceof Short) {
            return this.m_record.getIntValue("NON_UNIQUE") == 0;
        }
        return this.m_record.getBoolValue("NON_UNIQUE");
    }

    protected void addColumn(ColumnModel model) {
        this.m_columns.add(model);
    }

    void setColumn(int position, ColumnModel model) {
        if (this.m_columns == null) {
            this.m_columns = new ArrayList();
        }
        this.m_columns.add(position - 1, model);
    }

    protected void setRecord(SQLRecord record) {
        this.m_record = record;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexModel)) {
            return false;
        }
        IndexModel tm = (IndexModel)obj;
        boolean b = this.m_record.equals(tm.getRecord());
        if (!b || this.m_columns == null || this.m_columns.isEmpty()) {
            return b;
        }
        List cols = tm.getColumns();
        if (cols == null || cols.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            b = this.m_columns.get(i).equals(cols.get(i));
            if (b) continue;
            return b;
        }
        return true;
    }
}

