/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.util.ArrayList;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class ConstraintModel
implements SQLMetaModel {
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String FOREIGN_KEY = "FOREIGN KEY";
    public static final String CHECK = "CHECK";
    private SQLRecord m_record;
    private List m_columns;

    protected ConstraintModel() {
    }

    public ConstraintModel(String type, SQLRecord record) {
        if (!(PRIMARY_KEY.equals(type) || FOREIGN_KEY.equals(type) || CHECK.equals(type))) {
            throw new IllegalArgumentException("Constraint type must be PRIMARY KEY, FOREIGN KEY or CHECK");
        }
        this.m_record = record;
        this.m_record.setColumn(this.m_record.getColumnCount(), "TYPE", String.class, type);
    }

    public String getName() {
        return (String)this.m_record.getValue("NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getTableName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public String getType() {
        return this.m_record.getString("TYPE");
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setRecord(SQLRecord record) {
        this.m_record = record;
    }

    protected void setColumns(List columns) {
        this.m_columns = columns;
    }

    protected void addColumn(ColumnModel model) {
        if (this.m_columns == null) {
            this.m_columns = new ArrayList();
        }
        this.m_columns.add(model);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstraintModel)) {
            return false;
        }
        ConstraintModel tm = (ConstraintModel)obj;
        boolean b = this.m_record.equals(tm.getRecord());
        if (!b || this.m_columns == null || this.m_columns.isEmpty()) {
            return b;
        }
        List cols = tm.getColumns();
        if (cols == null || cols.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            b = this.m_columns.get(i).equals(cols.get(i));
            if (b) continue;
            return b;
        }
        return true;
    }
}

