/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import org.brains2b.sql.SQLHelper;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.SQLMetaModel;

public class ColumnModel
implements SQLMetaModel {
    private SQLRecord m_record;

    protected ColumnModel() {
    }

    public ColumnModel(SQLRecord record) {
        this.m_record = record;
        if (this.getDataType() == 1111 && this.getTypeName() != null) {
            this.correctOther(this.getTypeName());
        }
    }

    public String getName() {
        return this.m_record.getString("COLUMN_NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return "COLUMN";
    }

    public int getSequence() {
        return this.m_record.getIntValue("ORDINAL_POSITION");
    }

    public String getTableName() {
        return (String)this.getRecord().getValue("TABLE_NAME");
    }

    public int getDataType() {
        return this.getRecord().getIntValue("DATA_TYPE");
    }

    public String getTypeName() {
        return (String)this.getRecord().getValue("TYPE_NAME");
    }

    public int getColumnSize() {
        return this.getRecord().getIntValue("COLUMN_SIZE");
    }

    public int getDecimalDigits() {
        return this.getRecord().getIntValue("DECIMAL_DIGITS");
    }

    public boolean isNullable() {
        return this.getRecord().getString("IS_NULLABLE").equals("YES");
    }

    public String getRemarks() {
        return (String)this.getRecord().getValue("REMARKS");
    }

    public String getDefault() {
        return SQLHelper.stripQuotes((String)this.getRecord().getValue("COLUMN_DEF"));
    }

    public String toString() {
        return this.getTableName() + '.' + this.getName();
    }

    protected void setRecord(SQLRecord record) {
        this.m_record = record;
    }

    private final void correctOther(String typeName) {
        if ("BLOB".equals(typeName)) {
            this.m_record.setValue("DATA_TYPE", (Object)new Integer(2004));
        } else if ("CLOB".equals(typeName)) {
            this.m_record.setValue("DATA_TYPE", (Object)new Integer(2005));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnModel)) {
            return false;
        }
        ColumnModel tm = (ColumnModel)obj;
        return this.m_record.equals(tm.getRecord());
    }
}

